package com.digiwin.athena.knowledgegraph.configuration;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * MDC的rabbit,用于接收mdc发送的元数据信息，virtualhost与Athena用的不一致
 */
@Configuration
@Slf4j
@EnableRabbit
//@Import(RabbitProperties.class)
public class AthenaRabbitMQConfig {

    {
        System.out.println("========AthenaRabbitMQConfig init========");
    }

//    @Autowired
//    private RabbitProperties properties;

    @Value("${spring.rabbitmq.addresses}")
    private String addresses;

    @Bean("kgconnectionFactory")
  //  @Primary
    public ConnectionFactory kgconnectionFactory(){
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();

        RabbitProperties properties = new RabbitProperties();
        properties.setAddresses(addresses);

        connectionFactory.setHost(properties.determineHost());
        connectionFactory.setPort(properties.determinePort());
        connectionFactory.setUsername(properties.determineUsername());
        connectionFactory.setPassword(properties.determinePassword());
        connectionFactory.setVirtualHost(properties.determineVirtualHost());
        return connectionFactory;
    }


    @Bean(name="kgamqpAdmin")
   // @Primary
    public RabbitAdmin kgamqpAdmin() {
        return new RabbitAdmin(kgconnectionFactory());
    }

    @Bean(name="kgrabbitTemplate")
   // @Primary
    public RabbitTemplate kgrabbitTemplate(@Qualifier("kgconnectionFactory") ConnectionFactory connectionFactory){
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        return rabbitTemplate;
    }

    @Bean(name="kgrabbitListenerContainerFactory")
   // @Primary
    public SimpleRabbitListenerContainerFactory kgrabbitListenerContainerFactory(@Qualifier("kgconnectionFactory") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);

        return factory;
    }

}
