package com.digiwin.athena.knowledgegraph.configuration;

import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
public class KgMultilMongoConfig {


    @Autowired
    MongoClient mongo;
    @Autowired
    @Qualifier("mappingMongoConverterSystem")
    MongoConverter converter;

    @Bean("knowledgegraphSystem")
    public MongoTemplate knowledgegraphSystem(){
        SimpleMongoDbFactory mongoDbFactorySys = new SimpleMongoDbFactory(mongo, KnowledgeGraphDb.SYSTEM.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate(mongoDbFactorySys, converter);
        return mongoTemplateSys;
    }

    @Bean("knowledgegraphTenant")
    public MongoTemplate knowledgegraphTenant(){
        SimpleMongoDbFactory mongoDbFactorySys = new SimpleMongoDbFactory(mongo, KnowledgeGraphDb.TENANT.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate(mongoDbFactorySys, converter);
        return mongoTemplateSys;
    }

}
