package com.digiwin.athena.knowledgegraph.configuration;


import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;

import java.util.HashMap;
import java.util.Map;

/**
 MongoConfiguration.class,
 **/
@Configuration
//由AthenaRabbitMQConfig引入
//@Import({RabbitAutoConfiguration.class})
//@EnableNeo4jRepositories(basePackages = "com.digiwin.athena.knowledgegraph.repoNeo4j")
@Slf4j
public class ModuleConfiguration {

    public static final String APP_EXPIRE_EXCHANGE = "appExpireChange";

    {
        System.out.println("knowledgeGraph init..........");
    }

    @Value("${rabbitMQEnabled}")
    private String rabbitMQEnabled;
    @Value("${rabbitMQExchangeName}")
    private String rabbitMQExchangeName;
    @Value("${rabbitMQExchangeType}")
    private String rabbitMQExchangeType;
    @Value("${rabbitMQPersistent}")
    private String rabbitMQPersistent;
    @Value("${scheduleRuleConfigQueueName}")
    private String scheduleRuleConfigQueueName;
    @Value("${scheduleRuleConfigRoutingKey}")
    private String scheduleRuleConfigRoutingKey;
    @Value("${monitorRuleConfigQueueName}")
    private String monitorRuleConfigQueueName;
    @Value("${monitorRuleConfigRoutingKey}")
    private String monitorRuleConfigRoutingKey;

    @Value("${deadLetterExchangeName}")
    private String deadLetterExchangeName;
    @Value("${deadLetterScheduleRuleConfigQueueName}")
    private String deadLetterScheduleRuleConfigQueueName;
    @Value("${deadLetterScheduleRuleConfigRoutingKey}")
    private String deadLetterScheduleRuleConfigRoutingKey;
    @Value("${deadLetterMonitorRuleConfigQueueName}")
    private String deadLetterMonitorRuleConfigQueueName;
    @Value("${deadLetterMonitorRuleConfigRoutingKey}")
    private String deadLetterMonitorRuleConfigRoutingKey;
    @Value("${scheduleRuleConfigQueueTTL}")
    private long scheduleRuleConfigQueueTTL;
    @Value("${monitorRuleConfigQueueTTL}")
    private long monitorRuleConfigQueueTTL;

    @Value("${monitorCrossLevelQueueName}")
    private String monitorCrossLevelQueueName;
    @Value("${monitorCrossLevelRoutingKey}")
    private String monitorCrossLevelRoutingKey;

    // 用于推送侦测信息
    @Value("${monitorRuleConfigCDCRoutingKey}")
    private String monitorRuleConfigCDCRoutingKey;
    @Value("${monitorRuleConfigCDCQueueName}")
    private String monitorRuleConfigCDCQueueName;
    // 用于推送eoc变更信息
    @Value("${monitorCrossLevelCDCRoutingKey}")
    private String monitorCrossLevelCDCRoutingKey;
    @Value("${monitorCrossLevelCDCQueueName}")
    private String monitorCrossLevelCDCQueueName;






//    @Bean
//    public Queue scheduleRuleConfigQueueName() {
//        Map<String, Object> args = new HashMap<>(3);
//        args.put("x-dead-letter-exchange", deadLetterExchangeName);
//        args.put("x-dead-letter-routing-key", deadLetterScheduleRuleConfigRoutingKey);
//        args.put("x-message-ttl",scheduleRuleConfigQueueTTL);
//
//        if("false".equals(rabbitMQPersistent)){
//            return QueueBuilder.nonDurable(scheduleRuleConfigQueueName).withArguments(args).build();
//        }
//        return QueueBuilder.durable(scheduleRuleConfigQueueName).withArguments(args).build();
//    }

    @Bean
    public Queue monitorRuleConfigQueueName() {
        Map<String, Object> args = new HashMap<>(3);
        args.put("x-dead-letter-exchange", deadLetterExchangeName);
        args.put("x-dead-letter-routing-key", deadLetterMonitorRuleConfigRoutingKey);
        args.put("x-message-ttl",monitorRuleConfigQueueTTL);

        if("false".equalsIgnoreCase(rabbitMQPersistent)){
            return QueueBuilder.nonDurable(monitorRuleConfigQueueName).withArguments(args).build();
        }
        return QueueBuilder.durable(monitorRuleConfigQueueName).withArguments(args).build();
    }

    @Bean
    public Queue monitorRuleConfigCDCQueueName() {
//        Map<String, Object> args = new HashMap<>(3);
//        args.put("x-dead-letter-exchange", deadLetterExchangeName);
//        args.put("x-dead-letter-routing-key", deadLetterMonitorRuleConfigRoutingKey);
//        args.put("x-message-ttl",monitorRuleConfigQueueTTL);
//        log.info("monitorRuleConfigCDCQueueName begin ,monitorCrossLevelRoutingKey:" + monitorRuleConfigCDCQueueName);
//        return  QueueBuilder.durable(monitorRuleConfigCDCQueueName).withArguments(args).build();
        return new Queue(monitorRuleConfigCDCQueueName);
    }


    // 声明死信队列deadLetterMonitorRuleQueue
    @Bean("deadLetterMonitorRuleQueue")
    public Queue deadLetterMonitorRuleQueue(){
        return new Queue(deadLetterMonitorRuleConfigQueueName);
    }

    // 声明死信队列deadLetterScheduleRuleQueue
//    @Bean("deadLetterScheduleRuleQueue")
////    public Queue deadLetterScheduleRuleQueue(){
////        return new Queue(deadLetterScheduleRuleConfigQueueName);
////    }

    @Bean("monitorCrossLevelQueue")
    public Queue monitorCrossLevelQueue(){
        log.info("monitorCrossLevelQueue name:" + monitorCrossLevelQueueName);
        return new Queue(monitorCrossLevelQueueName);
    }

    @Bean("monitorCrossLevelCDCQueue")
    public Queue monitorCrossLevelCDCQueue(){
        log.info("monitorCrossLevelCDCQueue name:" + monitorCrossLevelCDCQueueName);
        return new Queue(monitorCrossLevelCDCQueueName);
    }

    @Bean
    Exchange rabbitMQExchange() {
        boolean persistent =true;
        if("false".equalsIgnoreCase(rabbitMQPersistent)){
            persistent=false;
        }
        if("topic".equals(rabbitMQExchangeType)){
            return  new TopicExchange(rabbitMQExchangeName,persistent,false);
        }else if("fanout".equals(rabbitMQExchangeType)){
            return new FanoutExchange(rabbitMQExchangeName,persistent,false);
        }
        return new DirectExchange(rabbitMQExchangeName,persistent,false);
    }

    // 声明死信Exchange
    @Bean("deadLetterExchange")
    public DirectExchange deadLetterExchange(){
        return new DirectExchange(deadLetterExchangeName);
    }

//    @Bean
//    Binding binding01() {
//        return BindingBuilder.bind(scheduleRuleConfigQueueName()).to(rabbitMQExchange()).with(scheduleRuleConfigRoutingKey).noargs();
//
//    }

    @Bean
    Binding binding02() {
        log.info("binding02 begin ,monitorRuleConfigRoutingKey:" + monitorRuleConfigRoutingKey);
        return BindingBuilder.bind(monitorRuleConfigQueueName()).to(rabbitMQExchange()).with(monitorRuleConfigRoutingKey).noargs();

    }

    //queue_corssLevel 绑定关系,用于侦测层级的改变
    @Bean
    Binding crossLevelQueue() {
        log.info("crossLevelQueue begin ,monitorCrossLevelRoutingKey:" + monitorCrossLevelRoutingKey);
        return BindingBuilder.bind(monitorCrossLevelQueue()).to(rabbitMQExchange()).with(monitorCrossLevelRoutingKey).noargs();

    }


    @Bean
    Binding bindingCdc() {
        log.info("bindingCdc begin ,monitorRuleConfigCDCRoutingKey:" + monitorRuleConfigCDCRoutingKey);
        return BindingBuilder.bind(monitorRuleConfigCDCQueueName()).to(rabbitMQExchange()).with(monitorRuleConfigCDCRoutingKey).noargs();

    }

    //queue_corssLevel 绑定关系,用于侦测层级的改变
    @Bean
    Binding crossLevelCDCQueue() {
        log.info("crossLevelCDCQueue begin ,monitorCrossLevelCDCRoutingKey:" + monitorCrossLevelCDCRoutingKey);
        return BindingBuilder.bind(monitorCrossLevelCDCQueue()).to(rabbitMQExchange()).with(monitorCrossLevelCDCRoutingKey).noargs();

    }

    // 声明死信队列Monitor绑定关系
    @Bean
    public Binding deadLetterBindingMonitorQueue(){
        return BindingBuilder.bind(deadLetterMonitorRuleQueue()).to(deadLetterExchange()).with(deadLetterMonitorRuleConfigRoutingKey);
    }

//    // 声明死信队列Schedule绑定关系
//    @Bean
//    public Binding deadLetterBindingScheduleQueue(){
//        return BindingBuilder.bind(deadLetterScheduleRuleQueue()).to(deadLetterExchange()).with(deadLetterScheduleRuleConfigRoutingKey);
//    }
//应用过期或者预约通知exchange

    @Bean
    public FanoutExchange appExpireChangeFanoutExchange(){
        return new FanoutExchange(APP_EXPIRE_EXCHANGE, true, false);
    }



}
