package com.digiwin.athena.knowledgegraph.configuration;

import com.digiwin.app.autoconfigure.DWHttpClientAutoConfiguration;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.http.client.DWHttpClientProperties;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.List;

@Configuration
public class RestTemplateConfiguration implements SmartInitializingSingleton {
    /**
     * 根据需要使用 HttpRouteUtils.DEFAULT_HTTPCLIENT_ROUTE_PLAN
     * 或者   HttpRouteUtils.ATTEMPT_HTTPCLIENT_ROUTE_PLAN （设置此值时 需设置 dwhttpClient.loadbalance.mode=auto    ）
     */
    @Autowired(required = false)
    @Qualifier(HttpRouteUtils.ATTEMPT_HTTPCLIENT_ROUTE_PLAN)
    HttpRoutePlanner httpRoutePlanner;

    /**
     * 请求重试机制
     */
    @Autowired(required = false)
    @Qualifier(DWHttpClientAutoConfiguration.BEAN_NAME_DW_HTTPCLIENT_REQUEST_RETRY_HANDLER)
    HttpRequestRetryHandler requestRetryHandler;
    /**
     * 重试机制
     */
    @Autowired(required = false)
    @Qualifier(DWHttpClientAutoConfiguration.BEAN_NAME_DW_HTTPCLIENT_RESPONSE_RETRY_STRATEGY)
    ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy;

    HttpClient httpClient;


    public RestTemplate initRT(boolean routePlanner, boolean retry) {
        DWEAIProperties dweaiProperties = new DWEAIProperties();
        dweaiProperties.setRestfulServiceBasePath("");
        DWEAIProperties.setProperties(dweaiProperties);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (routePlanner && null != httpRoutePlanner) {
            httpClientBuilder.setRoutePlanner(httpRoutePlanner);
        }
        if (retry && null != requestRetryHandler) {
            httpClientBuilder.setRetryHandler(requestRetryHandler);
        }
        if (retry && null != serviceUnavailableRetryStrategy) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        }
        PoolingHttpClientConnectionManager connectionManager = getConnectionManager();
        /** 设置整个连接池最大连接数 */
        connectionManager.setMaxTotal(200);
        /** 路由是对maxTotal的细分 */
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom()
                /** 返回数据的超时时间 */
                .setSocketTimeout(30000)
                /** 连接上服务器的超时时间 */
                .setConnectTimeout(5000)
                /** 从连接池中获取连接的超时时间 */
                .setConnectionRequestTimeout(5000)
                .build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager(connectionManager);
        httpClient = httpClientBuilder.setConnectionManagerShared(true).build();
        return new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient));
    }

    public RestTemplate initTagSystem(boolean routePlanner, boolean retry) {
        DWEAIProperties dweaiProperties = new DWEAIProperties();
        dweaiProperties.setRestfulServiceBasePath("");
        DWEAIProperties.setProperties(dweaiProperties);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (routePlanner && null != httpRoutePlanner) {
            httpClientBuilder.setRoutePlanner(httpRoutePlanner);
        }
        if (retry && null != requestRetryHandler) {
            httpClientBuilder.setRetryHandler(requestRetryHandler);
        }
        if (retry && null != serviceUnavailableRetryStrategy) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        }
        PoolingHttpClientConnectionManager connectionManager = getConnectionManager();
        /** 设置整个连接池最大连接数 */
        connectionManager.setMaxTotal(200);
        /** 路由是对maxTotal的细分 */
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom()
                /** 返回数据的超时时间 */
                .setSocketTimeout(60000)
                /** 连接上服务器的超时时间 */
                .setConnectTimeout(5000)
                /** 从连接池中获取连接的超时时间 */
                .setConnectionRequestTimeout(5000)
                .build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager(connectionManager);
        httpClient = httpClientBuilder.setConnectionManagerShared(true).build();
        return new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient));
    }

    public RestTemplate initSD(boolean routePlanner, boolean retry) {
        DWEAIProperties dweaiProperties = new DWEAIProperties();
        dweaiProperties.setRestfulServiceBasePath("");
        DWEAIProperties.setProperties(dweaiProperties);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (routePlanner && null != httpRoutePlanner) {
            httpClientBuilder.setRoutePlanner(httpRoutePlanner);
        }
        if (retry && null != requestRetryHandler) {
            httpClientBuilder.setRetryHandler(requestRetryHandler);
        }
        if (retry && null != serviceUnavailableRetryStrategy) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        }
        PoolingHttpClientConnectionManager connectionManager = getConnectionManager();
        /** 设置整个连接池最大连接数 */
        connectionManager.setMaxTotal(200);
        /** 路由是对maxTotal的细分 */
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom()
                /** 返回数据的超时时间 */
                .setSocketTimeout(30000)
                /** 连接上服务器的超时时间 */
                .setConnectTimeout(30000)
                /** 从连接池中获取连接的超时时间 */
                .setConnectionRequestTimeout(30000)
                .build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager(connectionManager);
        httpClient = httpClientBuilder.build();
        return new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient));
    }

    @Bean(name = "mdcRestTemplate")
    public RestTemplate mdcRestTemplate() {
        return initRT(true, true);
    }

    @Bean(name = "routeRestTemplate")
    public RestTemplate routeRestTemplate() {
        return initRT(true, true);
    }

    @Bean(name = "restTemplate")
    public RestTemplate restTemplate() {
        return initRT(true, true);
    }

    @Bean(name = "iamRestTemplate")
    public RestTemplate iamRestTemplate() {
        return initRT(false, true);
    }

    @Bean(name = "cacRestTemplate")
    public RestTemplate cacRestTemplate() {
        return initRT(false, true);
    }

    @Bean(name = "eocRestTemplate")
    public RestTemplate eocRestTemplate() {
        return initRT(false, true);
    }

    @Bean(name = "dmcRestTemplate")
    public RestTemplate dmcRestTemplate() {
        return initRT(false, true);
    }

    @Bean(name = "gmcRestTemplate")
    public RestTemplate gmcRestTemplate() {
        return initRT(false, true);
    }

    @Bean(name = "aimRestTemplate")
    public RestTemplate aimRestTemplate() {
        return initRT(true, true);
    }

    @Bean(name = "dataFootprintTemplate")
    public RestTemplate dataFootprintTemplate() {
        return initRT(true, true);
    }

    @Bean(name = "sdRestTemplate")
    public RestTemplate sdRestTemplate() {
        return initSD(true, true);
    }

    @Bean(name = "tagSystemRestTemplate")
    public RestTemplate tagSystemRestTemplate() {
        return initTagSystem(true, true);
    }

    @Override
    public void afterSingletonsInstantiated() {
        List<RestTemplate> beanList = JaSpringBeanUtil.getBeanList(RestTemplate.class);
        if (JaCollectionUtil.isNotEmpty(beanList)) {
            beanList.forEach(restTemplate -> JaSpringAopUtil.getSingletonTarget(restTemplate).getInterceptors().add(0, new AttachAppInfoInterceptor()));
        }
    }

    /**
     * 附加應用信息切片
     */
    public static class AttachAppInfoInterceptor implements ClientHttpRequestInterceptor {

        @Override
        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {

            AttachAppInfoInterceptor.attachAppAuthInfo(request.getURI().getHost(), request);

            return execution.execute(request, body);
        }

        /**
         * 附加應用授權信息
         *
         * @param host    請求目標
         * @param request 請求
         */
        public static void attachAppAuthInfo(String host, HttpRequest request) {

            HttpHeaders httpHeaders = request.getHeaders();
            // 1.檢查是否存在 app token 信息
            if (!httpHeaders.containsKey(DWRequestHeaderUtils.HEADER_IAM_API_APP_TOKEN)) {

                // 當環境中設置了 app token 且沒有排除此 host 時, 加上 app token 信息
                String apToken = DWHttpClientProperties.getProperties().getIamApToken();
                //暂无需根据请求的host判断,只对指定的restTemplate附加该Interceptor
                //if (apToken != null && !apToken.isEmpty() && !DWHttpClientProperties.getProperties()
                // .getAttachAppAuthInfoProperties().isExclude(host)) {
                if (apToken != null && !apToken.isEmpty()) {
                    httpHeaders.add(DWRequestHeaderUtils.HEADER_IAM_API_APP_TOKEN, apToken);
                }
            }
            // 2.檢查是否存在 app secret 信息(未纳入,暂不启用)
            /*if (!httpHeaders.containsKey(DWRequestHeaderUtils.HEADER_IAM_API_APP_SECRET)) {

                // 當環境中設置了 app token 且沒有排除此 host 時, 加上 app secret 信息
                String apSecret = DWHttpClientProperties.getProperties().getIamApSecret();
                if (apSecret != null && !apSecret.isEmpty() && !DWHttpClientProperties.getProperties()
                .getAttachAppAuthInfoProperties().isExclude(host))
                    httpHeaders.add(DWRequestHeaderUtils.HEADER_IAM_API_APP_SECRET, apSecret);
            }*/
        }
    }

    @Bean("httpClientConnectionManager")
    public PoolingHttpClientConnectionManager getConnectionManager() {
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", SSLConnectionSocketFactory.getSocketFactory())
                .build();
        return new PoolingHttpClientConnectionManager(registry);
    }

}
