package com.digiwin.athena.knowledgegraph.controller;


import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroup;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-05-12 18:28
 **/
@RestController
@RequestMapping("test")
public class TestController {

    private static Logger logger = LoggerFactory.getLogger(TestController.class);

    {
        System.out.println("TestController...........");
    }


    @Autowired
    private StringRedisTemplate redisTemplate;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;


    @PostMapping("/test/jugg")
    public String test() {
        ThreadContext.put(JaMDC.TraceId, JaMDC.get());
        Query query2 = Query.query(Criteria.where("code")
                .is("activityCode")
                .and("version")
                .is("activityVersion").and("tenantId")
                .is("tenantId"));
        Activity tenantActivity = mongoTemplateUser.findOne(query2, Activity.class,"activityConfigs");

        String demo = redisTemplate.opsForValue().get("demo");
        return "ok";
    }

    @RequestMapping("test01")
    public String test01() {

        logger.info("test01.............");

        CardGroup cardGroup = new CardGroup();
        cardGroup.setTenantId("tenantTuo01");
        cardGroup.setVersion("version111");

        mongoTemplateUser.save(cardGroup);

        return "ok";
    }

    /**
     * 获取Redis中所有key，并解析出string类型key的value，并统计value的大小，并统计大于10KB的value的数量
     *
     * @param pattern 匹配的key
     * @return
     */
    @RequestMapping("/getBigRedisKeyValue")
    public String getBigRedisKeyValue(@RequestParam("pattern") String pattern) {
        try {
            Map<String, Object> result = new HashMap<>();
            Set<String> keys = redisTemplate.keys(pattern);
            if (keys == null || keys.isEmpty()) {
                return "km相关key为空";
            }
            result.put("getBigRedisKeyValueScan解析km相关key数量", keys.size());
            logger.info("getBigRedisKeyValueScan解析km相关keys：{}，数量：{}", JsonUtil.toJsonString(keys), keys.size());
            Map<String, Object> stringKeyValueMap = new HashMap<>();
            Map<String, Object> stringKeyValueBigMap = new HashMap<>();
            Set<String> errorKeys = new HashSet<>();
            for (String key : keys) {
                try {
                    String value = redisTemplate.opsForValue().get(key);
                    int valueSize = String.valueOf(value).getBytes().length;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB > 10) {
                        stringKeyValueBigMap.put(key, valueSizeKB);
                    }
                } catch (RedisConnectionFailureException e) {
                    // 处理Redis连接失败异常
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis连接失败", e);
                } catch (Exception e) {
                    // 处理其他异常情况
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis的value发生异常", e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan返回结果：{}", JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        } catch (Exception e) {
            // 处理异常情况，可以记录日志或者返回错误信息
            logger.error("getBigRedisKeyValueScan获取Redis Key发生异常", e);
            return "getBigRedisKeyValueScan获取Redis Key发生异常";
        }
    }

    /**
     * 获取Redis中所有key，并解析出string类型key的value，并统计value的大小，并统计大于10KB的value的数量
     *
     * @param pattern 匹配的key
     * @return
     */
    @RequestMapping("/getBigRedisKeyValueScan")
    public String getBigRedisKeyValueScan(@RequestParam("pattern") String pattern) {
        try {
            Map<String, Object> result = new HashMap<>();
            ScanOptions options = ScanOptions.scanOptions().match(pattern).build();
            Set<String> keys = new HashSet<>();
            redisTemplate.execute((RedisCallback<Set<String>>) connection -> {
                try (Cursor<byte[]> cursor = connection.scan(options)) {
                    while (cursor.hasNext()) {
                        String key = new String(cursor.next(), StandardCharsets.UTF_8);
                        // 处理key，判断是否是string类型
                        DataType type = connection.type(key.getBytes());
                        if (type == DataType.STRING) {
                            keys.add(key);
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                return keys;
            });
            if (keys.isEmpty()) {
                return "km相关key为空";
            }
            result.put("getBigRedisKeyValueScan解析km相关key类型为String的数量", keys.size());
            logger.info("getBigRedisKeyValueScan解析km相关类型为String的keys：{}，数量：{}", JsonUtil.toJsonString(keys), keys.size());
            Map<String, Object> stringKeyValueMap = new HashMap<>();
            Map<String, Object> stringKeyValueBigMap = new HashMap<>();
            Set<String> errorKeys = new HashSet<>();
            for (String key : keys) {
                try {
                    String value = redisTemplate.opsForValue().get(key);
                    int valueSize = String.valueOf(value).getBytes().length;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB > 10) {
                        stringKeyValueBigMap.put(key, valueSizeKB);
                    }
                } catch (RedisConnectionFailureException e) {
                    // 处理Redis连接失败异常
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis连接失败", e);
                } catch (Exception e) {
                    // 处理其他异常情况
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis的value发生异常", e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan返回结果：{}", JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        } catch (Exception e) {
            // 处理异常情况，可以记录日志或者返回错误信息
            logger.error("getBigRedisKeyValueScan获取Redis Key发生异常", e);
            return "getBigRedisKeyValueScan获取Redis Key发生异常";
        }
    }

}
