package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.monitorRule.DynamicCondition;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

@Data
@Document(collection = "variableDefinition")
public class VariableDefinition extends CodedEntity {

    private String name;
    private String dataType;
    private String description;
    private Object defaultValue;

    //参数控件类型 PERCENT百分比控件
    private String displayType;
    //参数控件类型的详细定义
    private Object displayTypeDefinition;
    //参数控件显示格式
    private String displayFormat;//"yyyy-MM"
    //对应value的外显 可能是数组 [{"value":"true","label":"Y"},{"value":"false","label":"N"}]
    private Object valueDisplay;
    // 对应select的枚举值 可能是数组 [{"value":"true","label":"Y"},{"value":"false","label":"N"}]
    private Object options;
    //参数显示顺序
    private Integer sequence = 9999;
    //是否必填
    private Boolean required;
    //是否只读
    private Boolean readOnly;
    //参数校验
    private String validateScript;
    //控制参数是否可见 范围 ["param1","param2","param3"]
    private List<String> paramVisbleScope;
    //控制参数是否可见的键值匹配 {"true":"param1,param2","false":"param2,param3"}
    private Map paramVisble;
    //控制参数是否可编辑 范围 ["param1","param2","param3"]
    private List<String> paramDisableScope;
    //控制参数是否可编辑的键值匹配 {"true":"param1,param2","false":"param2,param3"}
    private Map paramDisable;
    //是否为执行参数
    private Boolean isExecute;
    //是否为模拟参数
    private Boolean isSimulation;
    //作为执行参数时的显示名称
    private String executeName;

    private Integer colspan;
    //参数的扩展数据 displayType为MONTH_PERIODIC时保存侦测规则id
    private String extendData;
    //参数类型 侦测周期period 变量variable 敏态参数
    private String category;
    //参数来源 espapi 表示参数来源于调用esp接口
    private String from = "default";
    //是否为运营单元参数
    private Boolean isOperation;
    //运营单元层级
    private Map eocLevel;

    //是否允许(立即)执行
    private Integer executable;
    //周期开关 分号分隔 M;W;D;H;F M每x月 W每x周 D每x天 H每x小时 F每x分钟
    private String periodEnable;
    //侦测动态条件下拉
    private Object fieldMappings;
    //侦测动态条件
    private Object dynamicCondition;

    //分组 同一组参数被归在一起 例如 控制能力 限制能力 决策能力 驱动能力
    private String group;

    //参数所属机制code
    private String mechanismCode;

    // 是否显示参数的条件对象
    private DynamicCondition visibleCondition;
    // 动态条件开窗：条件列字段与开窗key对应关系
    private List<FieldOpenWindowSetting> fieldOpenWindowMap;

    private Object value;

    private Boolean forceOpen;
    //弹窗 modal 或跳转 blank
    private String target;


    private String format;

    //当displayType为NUMBER时 控制输入的最大 最小 和 步进值
    private Integer max;
    private Integer min;
    private Integer step;
    //绑定哪个按钮的key 子联动控件的key
    private List<String> linkKey;

    //子联动控件的数据源  结构如下
    private Object linkOptions;

    // NUMBER类型的精度
    private String precision;

    //字段约束
    private Map<String, Object> restrictions;

    private String athena_namespace;

    private String pluginId;
    //参数过滤器定义
    private Map<String, Object> filters;

    /**
     * 下拉类型变量的选项设置
     */
    private SelectVariableOptionSetting selectVariableOptionSetting;

    /**
     * 变量值计算配置
     */
    private Map<String, Object> valueComputed;

    /**
     * 是否是单次操作
     */
    private Boolean isSingleOperation = Boolean.FALSE;

    /**
     * 单次操作弹窗提示文案
     */
    private String openWindowTip;

    /**
     * 置顶
     */
    private Boolean isTop;

    /**
     * 5767 交付设计器支持联动
     */
    private Object linkageParamEvent;

    /**
     * 应用 code
     */
    private String application;
}
