package com.digiwin.athena.knowledgegraph.domain.application;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @program: athena_backend
 * @description: 租户应用版本
 * @author: lingxiang
 * @create: 2022-04-20 16:00
 **/
@Data
@Document(collection = "appTenantVersion")
public class AppTenantVersion {
    /**
     * 主键id
     */
    @Id
    private String id;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 应用code
     */
    private String appCode;
    /**
     * 应用版本
     */
    private String appVersion;
    /**
     * 开发版本
     */
    private String devVersion;
}
