package com.digiwin.athena.knowledgegraph.domain.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.kg.domain.OperationUnitV2;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;

@Data
public class OperationUnit {
    /**
     * 公司ID
     */
    private String eoc_company_id;
    /**
     * 工厂ID
     */
    private String eoc_site_id;
    /**
     * 区域ID
     */
    private String eoc_region_id;

    /**
     * 运营单元信息v2
     */
    private OperationUnitV2 operation_unit_v2;

    @JSONField(serialize = false)
    public boolean isEmpty() {
        return StringUtils.isEmpty(eoc_company_id) && StringUtils.isEmpty(eoc_site_id) && StringUtils.isEmpty(eoc_region_id) && (operation_unit_v2 == null || StringUtils.isEmpty(operation_unit_v2.getEoc_mapping_id()));
    }

    /**
     * 是否为集团级
     * @return
     */
    public boolean isRegion() {
        // V2租户，判断是否为集团级
        if (operation_unit_v2 != null) {
            return operation_unit_v2.isRegion();
        }
        return isEmpty();
    }

    public Criteria addOperationToCriteria(Criteria criteria) {
        if (operation_unit_v2 != null && operation_unit_v2.getEoc_mapping_id() != null) {
            return new Criteria().andOperator(criteria, Criteria.where("operationUnit.operation_unit_v2.eoc_mapping_id").is(operation_unit_v2.getEoc_mapping_id()));
        }
        String companyId = null;
        String siteId = null;
        String regionId = null;
        if (this != null && !this.isEmpty()) {
            companyId = this.getEoc_company_id();
            siteId = this.getEoc_site_id();
            regionId = this.getEoc_region_id();
        }

        if (StringUtils.isNotEmpty(companyId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_company_id").is(companyId));
        } else {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_company_id").is(null));
        }
        if (StringUtils.isNotEmpty(siteId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_site_id").is(siteId));
        } else {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_site_id").is(null));
        }
        if (StringUtils.isNotEmpty(regionId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_region_id").is(regionId));
        } else {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_region_id").is(null));
        }
//        if(StringUtils.isEmpty(companyId) && StringUtils.isEmpty(siteId) && StringUtils.isEmpty(regionId)){
//            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit").is(null));
//        }
        return criteria;
    }
}