package com.digiwin.athena.knowledgegraph.domain.guide;

import com.digiwin.athena.domain.common.HierarchicalEntity;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 新手引导
 * @author: lingxiang
 * @create: 2022-05-18 16:00
 **/
@Data
@Document(collection = "guideConfig")
public class GuideConfig extends HierarchicalEntity {
    /**
     * 主键id
     */
    @Id
    private String id;
    /**
     * 应用code
     */
    private String appCode;
    /**
     * 项目 任务 code
     */
    private String code;
    /**
     * 类型 project task
     */
    private String type;
    /**
     * 明细设定
     */
    private List<GuideSetting> settings;
    /**
     * 开发版本
     */
    private String version;
    //多语言 name description
//    public Map<String, Map<String, String>> lang;

    @Override
    public String entityBizCode() {
        return code;
    }
}
