package com.digiwin.athena.knowledgegraph.domain.guide;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 新手引导明细 引用机制原理对象
 * @author: lingxiang
 * @create: 2022-05-23 17:00
 **/
@Data
public class GuideMechanismReference {
    private String mechanismCode;//机制code
    private String principleCode;//区块code
    private String detailCode;//内容code
    private List<Integer> lineNo;//机制原理principle的detail的content内 以/r/n分隔的行号数组 从1开始
    public boolean isEmpty() {//三个code必须都定义 引用不为空
        return StringUtils.isEmpty(mechanismCode) || StringUtils.isEmpty(principleCode) || StringUtils.isEmpty(detailCode);
    }
}
