package com.digiwin.athena.knowledgegraph.domain.inference;

import lombok.Data;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Labels;
import org.neo4j.ogm.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.QueryResult;

import java.util.Map;

/**
 * @author tang jie cheng
 * @date 2022-12-12 11:04
 */
@Data
//@QueryResult
public class InferenceEntity {
    @Id
    private Long id;

    private String name;

    private String code;

    private String version;

    @Labels
    private String label;

    private Object value;

    private Map<String, Map<String, String>> language;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        InferenceEntity that = (InferenceEntity) o;

        return new EqualsBuilder().append(version, that.version).append(code, that.code).append(label, that.label).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(code).append(label).append(version).toHashCode();
    }
}
