package com.digiwin.athena.knowledgegraph.domain.mechanism;

import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 租户设置表
 * @author: Tuo
 * @create: 2020-07-24 19:00
 **/
@Data
@Document
public class TenantSettings {

    private String id;
    private String tenantId;
    //应该是每个租户的每个业务型任务对应一个阀值,这里暂时定义一个租户对应一个
    private Double scheduleConstructionThreshold;
    private String scheduleConstructionFormulaId;
    private Long updateTime;
    private Map<String, Map<String, String>> lang;
    private String code;
    private List<ExecuteType> executeType;

}
