package com.digiwin.athena.knowledgegraph.domain.targets;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;

@Data
@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TBBTarget {

    /*
    "指标Key",  类型：String  必有字段，备注： 主键
     */
    private String IndicatorKey;

    @JSONField(name = "IndicatorKey")
    public String getIndicatorKey(){
        return this.IndicatorKey;
    }
    /*
    "语言",  类型：String  非必有字段(为兼容旧版)，备注： 主键，繁体: zh_TW  简体：zh_CN  如未传，默认为 zh_TW
     */
    private String Athena_lang;
    @JSONField(name = "Athena_lang")
    public String getAthena_lang(){
        return this.Athena_lang;
    }
    /*
    "期别",  类型：String  必有字段，备注：主键，以上三字段为联合主键
     */
    private String Period;
    @JSONField(name = "Period")
    public String getPeriod(){
        return this.Period;
    }
    /*
    "指标名称",  类型：String 必有字段
     */
    private String IndicatorName;
    @JSONField(name = "IndicatorName")
    public String getIndicatorName(){
        return this.IndicatorName;
    }
    /*
    "指标编号",  类型：String
     */
    /*private String IndicatorId;
    @JSONField(name = "IndicatorId")
    public String getIndicatorId(){
        return this.IndicatorId;
    }*/
    /*
    "指标值",  类型：Number
     */
    private Double IndicatorValue;
    @JSONField(name = "IndicatorValue")
    public Double getIndicatorValue(){
        return this.IndicatorValue;
    }
    private String CompanyNo;
    @JSONField(name = "CompanyNo")
    public String getCompanyNo(){
        return this.CompanyNo;
    }
    private String CompanyName;
    @JSONField(name = "CompanyName")
    public String getCompanyName(){
        return this.CompanyName;
    }
    private String DepartmentNo;
    @JSONField(name = "DepartmentNo")
    public String getDepartmentNo(){
        return this.DepartmentNo;
    }
    private String DepartmentName;
    @JSONField(name = "DepartmentName")
    public String getDepartmentName(){
        return this.DepartmentName;
    }
    /*
    "趋势类型",  类型：int 备注：0: 越大越好,1: 越小越好,2:趋于目标值
     */
    private Integer TrendType;
    @JSONField(name = "TrendType")
    public Integer getTrendType(){
        return this.TrendType;
    }
    /*
    "单位",  类型：String
     */
    private String Unit;
    @JSONField(name = "Unit")
    public String getUnit(){
        return this.Unit;
    }
    /*
    "周期类型",  类型：String
     */
    private String PeriodKind;
    @JSONField(name = "PeriodKind")
    public String getPeriodKind(){
        return this.PeriodKind;
    }
    /*
    "周期",  类型：String  备注：月:M季:Q 年:Y 日:D  [M,Q,Y,D]
     */
    private String Cycle;
    @JSONField(name = "Cycle")
    public String getCycle(){
        return this.Cycle;
    }
    /*
    "System":"产品",  类型：String 备注： [E10、 CM、 TipTop]
     */
    private String System;
    @JSONField(name = "System")
    public String getSystem(){
        return this.System;
    }
    /*
    "目标值",  类型：Number
     */
    private Double TargetValue;
    @JSONField(name = "TargetValue")
    public Double getTargetValue(){
        return this.TargetValue;
    }
    /*
    "高标",  类型：Number
     */
    private Double LowAlert;
    @JSONField(name = "LowAlert")
    public Double getLowAlert(){
        return this.LowAlert;
    }
    /*
    "低标",  类型：Number
     */
    private Double HighAlert;
    @JSONField(name = "HighAlert")
    public Double getHighAlert(){
        return this.HighAlert;
    }
    /*
    "制作人、归属人",  类型：String
     */
    private String MakeBy;
    @JSONField(name = "MakeBy")
    public String getMakeBy(){
        return this.MakeBy;
    }
    /*
    "备注",  类型：String
     */
    private String Remark;
    @JSONField(name = "Remark")
    public String getRemark(){
        return this.Remark;
    }

}
