package com.digiwin.athena.knowledgegraph.domain.targets;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TBBTargetTree {

    /*
    租户id
     */
    private String tenantId;
    /*
    "指标树根节点ID",   必有字段 ，类型：String  UUID字符串
     */
    private String treeId;
    /*
    "操作类型",类型：Int必有字段 备注：1 新增或修改,2 删除(只删除树节点，不删除指标)。如果操作类型是2删除，则以下节点属性都不需要了
     */
    private Integer operation;
    /*
    "指标Key"，类型：String， 必有字段
     */
    private String IndicatorKey;
    @JSONField(name = "IndicatorKey")
    public String getIndicatorKey(){
        return this.IndicatorKey;
    }
    /*
    "能力名称，节点名称"
     */
    private String nodeName;
    /*
    类型：String备注：vertical : 竖向  ,  horizontal 横向
     */
    private String direction;
    private TBBTreeNodeFormatter formatter;
    /*
    根节点不在此列表
     */
    private List<TBBTreeNode> children;

}
