package com.digiwin.athena.knowledgegraph.domain2.mechanism;

import com.digiwin.athena.kg.domain.DomainEntity;
import com.digiwin.athena.knowledgegraph.domain2.action.MechanismAction;
import lombok.Data;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-09-24 09:03
 **/
@Data
@NodeEntity(label = "Mechanism")
public class MechanismOld extends DomainEntity {

    private String key;
    private String name;
    private String description;
    //机制类型 1.classify分类型  2.bottleneck瓶颈型 3.指派型
    private String type;
    //当分类型机制时 指定分类列表
    @Relationship(type="CLASSIFICATION")
    private List<MechanismClassifyEntity> classifications;
    //机制内存在哪些公式
    @Relationship(type="SCENE")
    private List<MechanismScene> scenes;
    //机制的数据源
    @Relationship(type="dataAction")
    private List<MechanismAction> dataAction;
    @Relationship(type="TASKCONFIG")
    private List<TaskMechanismConfig> taskConfigs;


}
