package com.digiwin.athena.knowledgegraph.domain2.monitor;

import com.digiwin.athena.kg.domain.DomainEntity;

import com.digiwin.athena.kg.action.StartProcessAction;
import com.digiwin.athena.knowledgegraph.domain2.product.ProductSpecialMonitorRule;
import com.digiwin.athena.knowledgegraph.domain2.tenant.TenantSpecialMonitorRule;
import lombok.Data;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-09-29 11:17
 **/
@Data
public class MonitorRule extends DomainEntity {

    private String key;
    private String name;
    private String type;
    private String category;

    @Relationship(type="productConfig")
    private ProductSpecialMonitorRule productConfig;

    @Relationship(type="tenantConfig")
    private TenantSpecialMonitorRule tenantConfig;

    @Relationship(type="Triggers")
    private List<StartProcessAction> triggers;

    public String entityBizCode(){
        return key;
    }

}
