package com.digiwin.athena.knowledgegraph.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 待办工作台设定中的条件生效范围
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ConditionScopeDTO implements Serializable {

    @NotBlank
    private String appCode;

    private String appName;
    /**
     * 任务名称或项目名称
     */
    @NotBlank
    private String name;

    /**
     * 任务和项目编码
     */
    @NotBlank
    private String code;

    public Map<String, Map<String, String>> lang;

    private CardGroupTask cardGroupTask;

    /**
     * 原来老数据结构CardGroupApplication中的数据
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CardGroupTask {

        private String code;
        private String name;
        private boolean enabled;
        private boolean isDefault;
        public Map<String, Map<String, String>> lang;

    }
}
