package com.digiwin.athena.knowledgegraph.enums;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MechanismParameterTypeEnum implements IOption<String> {
    CUSTOMIZE("自定义") {
        @Override
        public Map<String, Object> getLang() {
            Map<String, String> map = new HashMap();
            map.put("en", "自定义");
            map.put("zh_CN", "自定义");
            map.put("zh_TW", "自定義");
            return ImmutableMap.of("name",map);
        }
    }, MECHANISM_PARAMETER("机制参数") {
        @Override
        public Map<String, Object> getLang() {
            Map<String, String> map = new HashMap();
            map.put("en", "机制参数");
            map.put("zh_CN", "机制参数");
            map.put("zh_TW", "機制參數");
            return ImmutableMap.of("name",map);
        }
    };
    private String name;
    MechanismParameterTypeEnum(String name) {
        this.name = name;
    }
    @JsonCreator
    public static MechanismParameterTypeEnum value(@JsonProperty("value") String value) {
        return StringUtils.isEmpty(value) ? null : Enum.valueOf(MechanismParameterTypeEnum.class, value);
    }

    @Override
    public String getValue() {
        return name();
    }

    public abstract Map<String, Object> getLang();

    public static List<Map> toList() {
        ObjectMapper om = new ObjectMapper();
        return Arrays.stream(MechanismParameterTypeEnum.values()).map(res -> om.convertValue(res, Map.class)).collect(Collectors.toList());
    }
}
