package com.digiwin.athena.knowledgegraph.enums;

import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.netty.util.Constant;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/***
 * 暫時實現每週的偵測數據生成
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TimeTypeEnum implements IOption<String> {
    week("day", Constants.ApiAction.PHP_TASK_OVERDUE_WARNING_TIME) {
        @Override
        public List<String> prefix() {
            return Stream.of("每周", "每週").collect(Collectors.toList());
        }

        @Override
        public Integer conversion(String desc) {
            return WeekDaysEnum.byDesc(desc).getCode();
        }
    }, day("day",Constants.ApiAction.PHP_TASK_OVERDUE_WARNING_TIME) {
        @Override
        public List<String> prefix() {
            return Stream.of("每天").collect(Collectors.toList());
        }

        @Override
        public String conversion(String desc) {
            return "";
        }
    }, month("day",Constants.ApiAction.PHP_TASK_OVERDUE_WARNING_TIME) {
        @Override
        public List<String> prefix() {
            return Stream.of("每月").collect(Collectors.toList());
        }

        @Override
        public Integer conversion(String desc) {
            return null;
        }
    }, hour("day","") {
        @Override
        public List<String> prefix() {
            return Stream.of("小时", "小時").collect(Collectors.toList());
        }

        @Override
        public String conversion(String desc) {
            return "";
        }
    };
    private String interval;

    private String timeValue;

    private String timeValueFixedValue;

    TimeTypeEnum(String interval,String timeValueFixedValue) {
        this.interval = interval;
        this.timeValueFixedValue=timeValueFixedValue;
    }

    public static TimeTypeEnum adapt(String monitorRuleValue) {
        return Arrays.stream(values()).filter(res -> extracted(monitorRuleValue, res)).findFirst().orElse(null);
    }

    private static boolean extracted(String monitorRuleValue, TimeTypeEnum res) {
        String prefixValue = res.prefix().stream().filter(prefix -> monitorRuleValue.startsWith(prefix)).findFirst().orElse(null);
        if (StringUtils.isNotBlank(prefixValue)) {
            String replace = monitorRuleValue.replace(prefixValue, "");
            Object conversion = res.conversion(replace);
            res.setTimeValue(conversion + ";");
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    public String getInterval() {
        return interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getTimeValue() {
        return timeValue;
    }

    public void setTimeValue(String timeValue) {
        this.timeValue = timeValue;
    }

    @Override
    public String getValue() {
        return name();
    }

    public abstract List<String> prefix();

    public abstract <R> R conversion(String desc);
}
