package com.digiwin.athena.knowledgegraph.mechanism;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import org.springframework.stereotype.Service;

/**
 * @author tang jie cheng
 * @date 2023-03-27 13:13
 */
@Service
public class MechanismCapacityLimitParser extends AbstractMechanismCapacityParser{

    @Override
    public boolean accept(MechanismCapacity capacity) {
        return ComponentTypeEnum.MechanismLimit.name().equals(capacity.getType());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismCapacity capacity) throws DWBusinessException {
        //限制能力为 时机
        super.parsePart(context, capacity.getSource());
        //条件 人员/业务条件
        super.parsePart(context, capacity.getCondition());
        //行动 欧博士提示
        super.parsePart(context, capacity.getAction());

    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismCapacity capacity, String parentNode) throws DWBusinessException {
//        super.generateCypherPart(context, capacity.getSource(), parentNode);
//        super.generateCypherPart(context, capacity.getCondition(), parentNode);
//        super.generateCypherPart(context, capacity.getAction(), parentNode);

        String sourceNode =super.doGenerateCypherPart(context, capacity.getSource());
        String checkNode =super.doGenerateCypherPart(context, capacity.getCondition());
        String actionNode =super.doGenerateCypherPart(context, capacity.getAction());
        super.doGenerateCypherPartRelation(context, checkNode, sourceNode,"condition");
        super.doGenerateCypherPartRelation(context, checkNode, actionNode,"ACTION");
    }
}
