package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.LimitTaskActionPart;
import com.digiwin.athena.mechanism.widgets.action.AutoProcess;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.AutoProcessPlan;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 限制能力  提示消息
 *
 * @author tang jie cheng
 * @date 2023-03-27 13:25
 */
@Service
@Slf4j
public class AutoProcessParser extends AbstractMechanismPartParser {

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.autoProcess.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart) part;
        AutoProcess autoProcess = limitTaskActionPart.getAutoProcess();
        LimitAbilityBo logic = (LimitAbilityBo) context.getLogic();
        for (SingleStrategyWidget strategy : logic.getStrategies()) {
            strategy.setCode(autoProcess.getCode());
            strategy.setActionHookType(MechanismEnum.ComponentType.ASSIGNMENT.getCode());
            AutoProcessPlan positiveTarget = JSON.parseObject(JSON.toJSONString(strategy.getPositiveTarget()),
                    AutoProcessPlan.class);
            positiveTarget.setType(MechanismPlanType.autoProcessPlan.name());
            positiveTarget.setActionType(MechanismEnum.LimitActionType.AUTO_PROCESS.getCode());
            positiveTarget.setParams((List<MechanismVariable>) context.getNamedParams().get(MechanismParseContext.Names.fields));
            positiveTarget.setParentParameter(autoProcess.getParentParameter());
            positiveTarget.setSubParameter(autoProcess.getSubParameter());
            strategy.setPositiveTarget(positiveTarget);
        }
        limitTaskActionPart.setStrategies(logic.getStrategies());
        if (null != logic) {
            logic.setAutoProcess(autoProcess);
        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart) part;
        List<SingleStrategyWidget> strategies = limitTaskActionPart.getStrategies();
        for (SingleStrategyWidget strategy : strategies) {
            super.generateCypherSimple(context, strategy, parentNode);
        }
    }
}
