package com.digiwin.athena.knowledgegraph.mechanism.partparsers;


import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.MechanismUtils;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismCheckType;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckKeyProcessIntegrationRatePart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.activity.GatewayWidget;
import com.digiwin.athena.mechanism.widgets.config.GatewayFlowPath;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * personInCharge
 */
@Service
public class CheckKeyProcessIntegrationRateParser  extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.CheckKeyProcessIntegrationRate.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        CheckKeyProcessIntegrationRatePart detail = (CheckKeyProcessIntegrationRatePart) part;
        String key1 = MechanismUtils.pathKey(detail.getPrimaryKeyPath());
        String key2 = MechanismUtils.pathParentKey(detail.getValueItemKeyPath());
        String key3 = MechanismUtils.pathKey(detail.getValueItemKeyPath());
        String key4 = MechanismUtils.pathKey(detail.getValueItemValuePath());
        String ratekey = detail.getRate().getMechanismVariableKey();
        String tablekey =detail.getProcessMaterialMapping().getMechanismVariableKey();
        String switchkey = detail.getSwitchParam().getMechanismVariableKey();

        MechanismAbility logic = context.getLogic();
        if(null==logic.getPreActivities()){
            logic.setPreActivities(new ArrayList<>());
        }
        List<String> variables = new ArrayList<>();
        variables.add(ratekey);
        variables.add(tablekey);
        variables.add(switchkey);

        //获取应用参数数据
        ActivityWidget activityWidget0 = MechanismUtils.getMechanismVariableActivity(variables);
        logic.getPreActivities().add(activityWidget0);

        //数据+应用参数 判断数据是否 todo 齐套率格式未定
        String scriptTempalte= AthenaUtils.loadStream("/mechanism/js/CheckKeyProcessIntegrationRate1.js");
        scriptTempalte=scriptTempalte.replaceAll("#key1#",key1);
        scriptTempalte=scriptTempalte.replaceAll("#key2#",key2);
        scriptTempalte=scriptTempalte.replaceAll("#key3#",key3);
        scriptTempalte=scriptTempalte.replaceAll("#key4#",key4);
        scriptTempalte=scriptTempalte.replaceAll("#ratekey#",ratekey);
        scriptTempalte=scriptTempalte.replaceAll("#tablekey#",tablekey);
        scriptTempalte=scriptTempalte.replaceAll("#switchkey#",switchkey);
        ActivityWidget activityWidget1 = MechanismUtils.scriptActivityWidget("过滤关键物料不达标",scriptTempalte);
        logic.getPreActivities().add(activityWidget1);

        //如果没有数据则结束流程，这里时导向一个不会对外输出的节点
        if(null==logic.getPostActivities()){logic.setPostActivities(new ArrayList<>());}
        GatewayWidget gatewayWidget =new GatewayWidget();
        gatewayWidget.setType("gateway");
        gatewayWidget.setFlowPaths(new ArrayList<>());
        GatewayFlowPath nodataPath = new GatewayFlowPath();
        nodataPath.setNotOutput(true);
        CheckWidget checkdata = new CheckWidget();
        checkdata.setType(MechanismCheckType.expression.name());
        String taskCode = logic.getCheckSource().getTarget();
        // S12合并工时机制能力选择合并工时时只要有物料不齐套就不发卡的处理 暂时
        if ("apc_mergeEocToUser".equalsIgnoreCase(taskCode) || "POC_copy_2_AthenaQCTestW_task_0006".equalsIgnoreCase(taskCode)) {
            // 开关开启并且齐套率不达标
            checkdata.setExpression("$(switchValue) && $(badData).length > 0");
        }else {
            // 开关开启并且齐套率不达标
            checkdata.setExpression("$(switchValue) && $(data).length==0");
        }
        nodataPath.setCondition(checkdata);
        gatewayWidget.getFlowPaths().add(nodataPath);
        logic.getPostActivities().add(gatewayWidget);

        //设置发送im消息条件
        CheckWidget condition = new CheckWidget();
        condition.setType("expression");
        condition.setExpression("$(switchValue) && $(badData).length > 0");

        context.getNamedParams().put(MechanismParseContext.Names.checkCondition,condition);
        context.getNamedParams().put(MechanismParseContext.Names.im_userId,"'$(personInCharge)'");
        context.getNamedParams().put(MechanismParseContext.Names.im_performerId,"$(performerId)");

    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {

    }


    public static void main(String[] args) {
        List<String> str = new ArrayList<>();
        str.add("aa");str.add("bb");
        String ss = StringUtils.join(str,",");
        System.out.println(ss);

    }
}
