package com.digiwin.athena.knowledgegraph.mechanism.partparsers;


import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskByQuantityPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskOnTimeOverPart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.check.CheckByQuantity;
import com.digiwin.athena.mechanism.widgets.check.CheckCompleteParam;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @program: codes
 * @description: 仅适用于source是侦测的情况
 * @author: Tuo
 * @create: 2023-03-09 15:19
 **/
@Slf4j
@Service
public class CheckTaskByQuantityParser extends AbstractMechanismPartParser {

    @Autowired
    TaskService taskService;
    @Autowired
    ActionService actionService;
    @Autowired
    DataMapService dataMapService;

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.checkTaskByQuantity.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        // 将 part 转换为 CheckTaskOnTimeOverPart 类型
        CheckTaskByQuantityPart checkPart = (CheckTaskByQuantityPart) part;
        // 获取上下文中的逻辑和检查来源
        DriveAbilityBo logic = (DriveAbilityBo) context.getLogic();
        ScheduleSourceWidget checkSource = (ScheduleSourceWidget) logic.getCheckSource();
        MonitorRule rule = checkSource.getMonitorRule();

        // 如果规则的静态参数列表为空，则创建一个空列表
        if (null == rule.getStaticParams()) {
            rule.setStaticParams(new ArrayList<>());
        }

        // 如果逻辑中的预活动列表为空，则创建一个空列表
        if (null == logic.getPreActivities()) {
            logic.setPreActivities(new ArrayList<>());
        }
        if (null == checkPart.getCheckByQuantity()) {
            throw new DWBusinessException("checkField is required by CheckTaskByQuantityPart");
        }
        String checkType = checkPart.getCheckByQuantity().getObjectType();
        // 获取检查作业
        String jobCode = checkPart.getCheckByQuantity().getJobCode();
        CheckByQuantity checkByQuantity = checkPart.getCheckByQuantity();
        if (StringUtils.isEmpty(checkType)) {
            // 如果检查作业为空，则抛出异常
            throw new DWBusinessException("checkType is required by CheckTaskByQuantityPart");
        }
        // 如果检查作业是项目任务
        if ("1".equals(checkType)) {
            // 检查是否设置了 checkField 字段，如果没有则抛出异常
            if (StringUtils.isEmpty(jobCode)) {
                throw new DWBusinessException("jobCode is required by CheckTaskByQuantityPart");
            }
            generateActivityWidget(jobCode, checkByQuantity, rule, logic, checkPart, checkPart.getCheckByQuantity().getFullPath());
            // 给数据打上轻量级侦测标签，用于二次编译时取消直接创建侦测，改为放置定义
            Task task = new Task();
            task.setCode(jobCode);
            task.setNeedScheduledTaskDetail(Boolean.TRUE);
            task.setNeedLightDetection(Boolean.TRUE);
            task.setVersion(context.getTenantVersion());
            dataMapService.updateTaskScheduleFlag(task);
            logic.setNeedLightDetection(Boolean.TRUE);
            // 如果是轻量级侦测，projectCode使用uuid
            logic.setProjectCode(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        }

        // 如果检查作业是业务数据录入
        if ("3".equals(checkType)) {
            // 检查是否设置了 checkField 字段，如果没有则抛出异常
            if (StringUtils.isEmpty(jobCode)) {
                throw new DWBusinessException("jobCode is required by CheckTaskByQuantityPart");
            }
            generateActivityWidget(jobCode, checkByQuantity, rule, logic, checkPart, "data");
//            logic.setNeedLightDetection(Boolean.TRUE);
//            Task task = new Task();
//            task.setCode(jobCode);
//            task.setNeedLightDetection(Boolean.TRUE);
//            dataMapService.updateTaskScheduleFlag(task);
        }
    }

    private void generateActivityWidget(String jobCode, CheckByQuantity checkByQuantity, MonitorRule rule,
                                        DriveAbilityBo logic, CheckTaskByQuantityPart checkPart, String dataName) throws DWBusinessException {
        // 检查是否设置了 checkField 字段，如果没有则抛出异常
        String businessConditionStr = JSON.toJSONString(checkByQuantity.getBusinessCondition());
        String quantityConditionStr = JSON.toJSONString(checkByQuantity.getQuantityCondition());
        // 获取
        rule.setMonitorActionId("mechanism_CheckTaskByQuantityOfBaseDataAction");

        // 添加参数
        DynamicParam param1 = new DynamicParam();
        param1.setParam_name("code");
        param1.setParam_value(jobCode);
        rule.getStaticParams().add(param1);

        // step1 根据返回数据做过滤
        ActivityWidget activityWidget1 = new ActivityWidget();
        activityWidget1.setType("script");
        activityWidget1.setConfig(new HashMap<>());
        activityWidget1.getConfig().put("executionMode", "script");
        Map<String, String> scriptMode = new HashMap<>();
        scriptMode.put("requestScript", "");
        String responseScript = "var data = $(data); var processData = data[0]['" + dataName + "']; return {processVariable: { dataList: processData} }";
        //responseScript = responseScript.replace("#checkDay#", cd.toString());
        scriptMode.put("responseScript", responseScript);
        activityWidget1.getConfig().put("scriptMode", scriptMode);
        activityWidget1.setName("返回所有进行中的包含流程变量任务");
        logic.getPreActivities().add(activityWidget1);
        checkPart.setActivityWidget0(activityWidget1);

        // step2 在将整包数据通过调用kg定制api进行过滤
        ActivityWidget activityWidget2 = new ActivityWidget();
        activityWidget2.setType("http");
        activityWidget2.setConfig(new HashMap<>());
        activityWidget2.getConfig().put("executionMode", "script");
        activityWidget2.getConfig().put("method", "post");
        activityWidget2.getConfig().put("domain", "thememap");
        activityWidget2.getConfig().put("contentType", "json");
        activityWidget2.getConfig().put("url", "/restful/service/knowledgegraph/mechanismEnhancement/filterByQuantity");
        String kgRequestScript = "var request = { \"dataList\": $(dataList), " +
                "\"businessCondition\": #businessCondition#, \"quantityCondition\": #quantityCondition#}; return request;";
        kgRequestScript = kgRequestScript.replace("#businessCondition#", businessConditionStr);
        kgRequestScript = kgRequestScript.replace("#quantityCondition#", quantityConditionStr);
        String kgResponseScript = "var data = $(response); var processData = data['response']; return {processVariable: { taskBizData: processData, list : processData} }";
        HashMap<Object, Object> scriptMode2 = new HashMap<>();
        scriptMode2.put("requestScript", kgRequestScript);
        scriptMode2.put("responseScript", kgResponseScript);

        activityWidget2.getConfig().put("scriptMode", scriptMode2);
        activityWidget2.setName("返回包含业务数据的任务");
        logic.getPreActivities().add(activityWidget2);
        checkPart.setActivityWidget1(activityWidget2);
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        CheckTaskOnTimeOverPart checkPart = (CheckTaskOnTimeOverPart) part;
        CheckCompleteParam widget = checkPart.getCheckComplete();
        ActivityWidget activityWidget0 = checkPart.getActivityWidget0();
        ActivityWidget activityWidget1 = checkPart.getActivityWidget1();
        if (null != activityWidget0) {
            super.generateCypherActivity(context, activityWidget0, parentNode);
        }
        if(null!=activityWidget1){
            super.generateCypherActivity(context,activityWidget1,parentNode);
        }
    }
}
