package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ConditionsPart;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.PersonnelCondition;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.config.RuleTrigger;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * 限制能力  人员条件
 *
 * @author tang jie cheng
 * @date 2023-03-27 13:25
 */
@Service
@Slf4j
public class PersonnelConditionParser extends AbstractMechanismPartParser {

    @Autowired
    IMechanismService mechanismService;

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.personnelCondition.equals(part.getCode());
    }


    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        ConditionsPart conditionsPart = (ConditionsPart) part;
        PersonnelCondition personnelCondition = conditionsPart.getPersonnelCondition();
        handlePersonnelCondition(context, personnelCondition);
        String performerType = personnelCondition.getPerformerType();
        LimitAbilityBo logic = (LimitAbilityBo) context.getLogic();
        List<SingleStrategyWidget> strategies = ObjectUtils.isEmpty(logic.getStrategies()) ? new ArrayList<>() :
                logic.getStrategies();
        SingleStrategyWidget singleStrategyWidget = new SingleStrategyWidget();
        singleStrategyWidget.setType("singleChoose");
        singleStrategyWidget.setPersonnelCondition(personnelCondition);
        LimitPlan limitPlan = new LimitPlan();
        limitPlan.setLimitType(performerType);
        limitPlan.setConditionPatch(personnelCondition.getConditionPatch());
        limitPlan.setConditionType(MechanismCapacityCodes.personnelCondition);
        parseReminder(context,  performerType, limitPlan);
        singleStrategyWidget.setPositiveTarget(limitPlan);
        strategies.add(singleStrategyWidget);
        logic.setStrategies(strategies);

        if (null != logic) {
            logic.setPersonnelCondition(personnelCondition);
        }
    }

    /**
     * 处理员工条件
     * @param context
     * @param personnelCondition
     */
    private void handlePersonnelCondition(MechanismParseContext context, PersonnelCondition personnelCondition){
        String performerType = personnelCondition.getPerformerType();
        if("proficiency".equalsIgnoreCase(performerType)){
            String type = context.getTargetSource().getType();
            String workType = "";
            if ("dataEntrySource".equalsIgnoreCase(type)) {
                workType = "BASE-DATA";
            } else if ("taskSource".equalsIgnoreCase(type)) {
                workType = "TASK";
            } else if ("projectSource".equalsIgnoreCase(type)) {
                workType = "START-PROJECT";
            }
            personnelCondition.setWorkCode(context.getTargetSource().getTarget());
            personnelCondition.setWorkType(workType);
        }
    }

    public void parseReminder(MechanismParseContext context,  String performerType, LimitPlan limitPlan) {
//        ConditionsPart conditionsPart = (ConditionsPart) part;
//        PersonnelCondition personnelCondition = conditionsPart.getPersonnelCondition();
//        String performerType = personnelCondition.getPerformerType();
//        LimitAbilityBo logic = (LimitAbilityBo) context.getLogic();
//        List<SingleStrategyWidget> strategies = ObjectUtils.isEmpty(logic.getStrategies()) ? new ArrayList<>() :
//                logic.getStrategies();
//        SingleStrategyWidget singleStrategyWidget = new SingleStrategyWidget();
//        singleStrategyWidget.setType("singleChoose");
//        singleStrategyWidget.setPersonnelCondition(personnelCondition);
//        LimitPlan limitPlan = new LimitPlan();
        RuleContent ruleContent = new RuleContent();
        RuleTrigger ruleTrigger = new RuleTrigger();
        ruleTrigger.setType("async");
//        limitPlan.setLimitType(performerType);
//        limitPlan.setConditionPatch(personnelCondition.getConditionPatch());
        switch (performerType) {
            case "duty":
                // TODO 由于目前欧博士弹窗必须要通过 api-trigger 触发，所以这里给 staff 类型也添加上 api，其实没用，后续需要给小 AI 代码支持上非 aoi-trigger 的方式
            case "staff":
                ruleTrigger.setApiUrl("/api/eoc/v2/duty/list?pageSize=99999");
                ruleTrigger.setApiPrefixType("eocUrl");
                ruleTrigger.setMethod("GET");
                ruleTrigger.setApiMethodType("get");
                limitPlan.setIsAsync(true);
                break;
            case "proficiency":
                String type = context.getTargetSource().getType();
                //workType  TASK任务 基础资料
                String workType = "";
                if ("dataEntrySource".equalsIgnoreCase(type)) {
                    workType = "BASE-DATA";
                } else if ("taskSource".equalsIgnoreCase(type)) {
                    workType = "TASK";
                } else if ("projectSource".equalsIgnoreCase(type)) {
                    workType = "START-PROJECT";
                }
                //操作类型 提交时
                String operations = "OPEN";
                ruleTrigger.setApiUrl("/api/v1/user/track/search");
                ruleTrigger.setApiPrefixType("audcUrl");
                ruleTrigger.setApiMethodType("post");
                ruleTrigger.setMethod("POST");
                ruleTrigger.setParameterScript("const {userId, tenantId} = JSON.parse(sessionStorage.getItem" +
                        "('DwUserInfo'));return {'workType':'" + workType + "','workCode':'" + context.getTargetSource().getTarget() + "', " +
                        "'operations':['" + operations + "'],'userId':userId,'tenantId':tenantId}");
                limitPlan.setIsAsync(true);
                break;
        }
        ruleContent.setTrigger(ruleTrigger);
        limitPlan.setRuleContent(ruleContent);
//        singleStrategyWidget.setPositiveTarget(limitPlan);
//        strategies.add(singleStrategyWidget);
//        logic.setStrategies(strategies);
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        ConditionsPart conditionsPart = (ConditionsPart) part;
        String code = conditionsPart.getCode();
        String nodeId = "widget_" + UUID.randomUUID().toString().replaceAll("-", "");
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{")
                .append("code").append(":'").append(code).append("',")
                .append("name").append(":'").append("人员条件").append("',")
                .append("type").append(":'").append("personnelCondition").append("',")
                .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                .append("})\r\n")
        ;
        context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")" +
                "\r\n");
    }
}
