package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.DecisionSubType;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.SourceTaskDecisionPart;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-30 16:54
 **/
@Service
public class SourceTaskDecisionParser extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.sourceTaskDecision.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        SourceTaskDecisionPart sourcePart = (SourceTaskDecisionPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        DecisionAbilityBO logic = (DecisionAbilityBO) context.getLogic();
        logic.setCheckSource(targetSource);
        logic.setVariable(sourcePart.getVariable());
        logic.setSubType(DecisionSubType.option.name());


    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        SourceTaskDecisionPart sourcePart = (SourceTaskDecisionPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        super.generateCypherSimple(context,targetSource,parentNode);
    }
}
