package com.digiwin.athena.knowledgegraph.po;

import com.digiwin.athena.kg.domain.DomainEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;


/**
 *
 * 部署消息PO
 * {@link com.digiwin.athena.knowledgegraph.vo.DeployMessageVO}注意关联修改
 * @author tang jie cheng
 * @date 2023-02-13 10:53
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Document(collection = "deployMessage")
public class DeployMessagePO extends DomainEntity {

    /**
     * mongoId
     */
    @Id
    private String mongoId;

    /**
     * 状态
     */
    private Integer status = 1;

    /**
     * 标题
     */
    private String title;

    /**
     * 编码
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 部署节点
     */
    private String deployNote;

    /**
     * 序列号
     */
    private int sequence;

    /**
     * 更新时间
     */
    private String updateTime = "2000-01-01 00:00:00";

    /**
     * 信息级别
     */
    private Integer infoLevel = 0;

    /**
     * 详情
     */
    private Object details;
}
