package com.digiwin.athena.knowledgegraph.product;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.product.model.ProductTenantConfigDO;
import com.digiwin.athena.knowledgegraph.product.model.ProductTypeEnum;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import org.bson.Document;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

public class ProductTenantConfigManager {
    private static final String PRODUCT_CONFIG_COLLECTION_NAME = "productTenantConfig";

    private static final String PRODUCT_CONFIG_INDEX_NAME = "idx_ProductTenantConfig";
    public static final String TENANT_ID_FIELD = "tenantId";
    public static final String PRODUCT_NAME_FIELD = "productName";
    public static final String TYPE_FIELD = "type";

    public ProductTenantConfigDO readTenantConfig(String tenantId, String productName, ProductTypeEnum type) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, PRODUCT_NAME_FIELD);
        //获取的配置必须是启用状态
        Document doc = col.find(and(eq(PRODUCT_NAME_FIELD, productName), eq(TENANT_ID_FIELD, tenantId))).first();
        if (doc != null) {
            ProductTenantConfigDO tenantConfigDO = JSON.parseObject(doc.toJson(), ProductTenantConfigDO.class);
            return tenantConfigDO;
        }
        else
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.productNotFound",tenantId,productName));
    }

    public ProductTenantConfigDO readTenantConfig(String tenantId, ProductTypeEnum type) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, PRODUCT_NAME_FIELD);
        //获取的配置必须是启用状态
        Document doc = col.find(and(eq(TYPE_FIELD, type.toString()), eq(TENANT_ID_FIELD, tenantId))).first();
        if (doc != null) {
            ProductTenantConfigDO tenantConfigDO = JSON.parseObject(doc.toJson(), ProductTenantConfigDO.class);
            return tenantConfigDO;
        }
        else
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.productNotFound2",tenantId));
    }
}