package com.digiwin.athena.knowledgegraph.pullingMap.model;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.UUID;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class FormulaActionDO {

    private String actionId;
    private String expression;
    private String target;
    private String name;
    private List<ApiDataFieldMetadataDTO> request;
    private ApiDataFieldMetadataDTO response;

    public String GenerateFormulaCreateScript(String nameSpace) {
        String uid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
        return String.format("create (formulaAction:FormulaAction:Action {id:'%1$s',actionId:'%2$s', version:'2.0',expression:'%3$s',target:'%4$s',name:'%5$s', innerType:'FormulaAction', request_parameters:'%6$s', response_object:'%7$s', nameSpace:'%8$s'})",
                uid, this.actionId, this.expression, this.target, this.name, this.request.size() == 0 ? "" : JSON.toJSON(this.request), this.response == null ? "" : JSON.toJSON(this.response),nameSpace);
    }

}
