package com.digiwin.athena.knowledgegraph.pullingMap.service;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.data.Neo4jConstants;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service
@Slf4j
@MyExceptionHandler
public class EntityAndDependencyGeneratorService {
    @Autowired
    KgHelpService kgHelpService;

    @Autowired
    private ActionRepository actionRepository;

    @Autowired
    private DataPickService dataPickService;

//    //request字段的Map，key是request字段全路径，value是request字段uid
//    private ConcurrentHashMap<String, List<ActionFiled>> requestFieldMap = new ConcurrentHashMap<>();
//    //response字段的Map，key是response字段全路径，value是response字段uid
//    private ConcurrentHashMap<String, List<ActionFiled>> responseFieldMap = new ConcurrentHashMap<>();

    public void BuildAll() throws Exception {
        CreateEntitiesAndFields();
        CreateFieldMap();
    }

    public void BuildOne(String actionId,String nameSpace) {
        List<Action> actionList = dataPickService.excludeWithSameCode(actionRepository.findByActionId(actionId));
        /*String queryStatement = "MATCH (action:Action) where action.actionId='" + actionId + "' and action.nameSpace='" + nameSpace + "' return action.actionId as actionId, action.request_parameters as parameters, action.response_object as response";
        List<Map<String, Object>> actionQueryResult = Neo4jManager.getNeo4jManager().ExecuteQuery(queryStatement);*/
        if (actionList.size() == 0) {
            System.err.println("Failed to build metadata for [" + actionId + "], no action matched found");
            return;
        }
        if (actionList.size() > 1) {
            System.err.println("Failed to build metadata for [" + actionId + "], more than action matched found");
            return;
        }
        for (Action record : actionList) {
            String parametersString = record.getRequest_parameters().toString().replaceAll("\\\\", "");
            List<ApiDataFieldMetadataDTO> parameters = JSON.parseArray(parametersString, ApiDataFieldMetadataDTO.class);
            if (parameters != null) {
                for (ApiDataFieldMetadataDTO parameter : parameters) {
                    CreateParameter(parameter, actionId, nameSpace, false, null);
                }
            }
            String responseString = record.getResponse_object().toString().replaceAll("\\\\", "");
            ApiDataFieldMetadataDTO response = JSON.parseObject(responseString, ApiDataFieldMetadataDTO.class);
            CreateResponseEntity(response, actionId, nameSpace, false, null);
        }
    }

    private void CreateEntitiesAndFields() {
        String queryStatement = "MATCH (action:EspAction) return action.actionId as actionId, action.tenantId as tenantId, action.request_parameters as parameters, action.response_object as response";
        List<Map<String, Object>> actionQueryResult = Neo4jManager.getNeo4jManager().ExecuteQuery(queryStatement);
        actionQueryResult.parallelStream().forEach(record -> {
            String actionId = record.get("actionId").toString();
            // 是不是个案ESP
            Boolean singleCase = "NULL".equals(record.get("tenantId"));
            String tenantId = singleCase ? record.get("tenantId").toString() : null;
            try {
                System.out.println(Thread.currentThread().getName() + "--->>" + "api createEntitiesAndFields: " + actionId);
                String parametersString = record.get("parameters").toString().replaceAll("\\\\", "");
                List<ApiDataFieldMetadataDTO> parameters = JSON.parseArray(parametersString, ApiDataFieldMetadataDTO.class);
                if (parameters != null) {
                    for (ApiDataFieldMetadataDTO parameter : parameters) {
                        CreateParameter(parameter, actionId, "espCommon", singleCase, tenantId);
                    }
                }
                String responseString = record.get("response").toString().replaceAll("\\\\", "");
                ApiDataFieldMetadataDTO response = JSON.parseObject(responseString, ApiDataFieldMetadataDTO.class);
                CreateResponseEntity(response, actionId, "espCommon", singleCase, tenantId);
            } catch (Exception e) {
                System.err.println(Thread.currentThread().getName() + "--->>" + "api解析失败！！清检查API元数据: " + actionId);
            }

        });
    }

    private void CreateParameter(ApiDataFieldMetadataDTO metadata, String actionId, String nameSpace, Boolean singleCase, String tenantId) {
        if (!metadata.getData_type().equals("object")) {
            String fieldUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID, tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (field:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})",
                    Neo4jConstants.LABEL_DATA_FIELD,
                    Neo4jConstants.PROPERTY_NAME, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_DESCRIPTION, (metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN()),
                    Neo4jConstants.PROPERTY_UID, fieldUid,
                    Neo4jConstants.PROPERTY_DATA_FIELD_FULL_PATH, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_NAMESPACE, nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(field)",
                    Neo4jConstants.RELATION_REQUIRES));

//            Neo4jManager.getNeo4jManager().ExecuteNoQuery(statementBuilder.toString());
            kgHelpService.executeCyhper(statementBuilder.toString(),new HashMap<>());

        } else {
            String entityUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID, tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (entity:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})",
                    Neo4jConstants.LABEL_DATA_ENTITY,
                    Neo4jConstants.PROPERTY_NAME, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_DESCRIPTION, (metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN()),
                    Neo4jConstants.PROPERTY_UID, entityUid,
                    Neo4jConstants.PROPERTY_DATA_FIELD_FULL_PATH, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_NAMESPACE, nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(entity)",
                    Neo4jConstants.RELATION_REQUIRES));

//            Neo4jManager.getNeo4jManager().ExecuteNoQuery(statementBuilder.toString());
            kgHelpService.executeCyhper(statementBuilder.toString(),new HashMap<>());

            if (metadata.getField() == null || metadata.getField().size() == 0) {
                return;
            }
            for (ApiDataFieldMetadataDTO fieldDTO : metadata.getField()) {
                if (fieldDTO.getData_type().equals("object")) {
                    CreateDetailEntity(fieldDTO, entityUid, metadata.getData_name(), true, actionId, nameSpace);
                } else {
                    CreateParameterField(fieldDTO, entityUid, metadata.getData_name(), true, actionId, nameSpace);
                }
            }
        }
    }

    private void CreateResponseEntity(ApiDataFieldMetadataDTO metadata, String actionId, String nameSpace, Boolean singleCase, String tenantId) {
        if (metadata == null) {
            return;
        }
        if (!metadata.getData_type().equals("object")) {
            String fieldUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID, tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (field:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\"})",
                    Neo4jConstants.LABEL_DATA_FIELD,
                    Neo4jConstants.PROPERTY_NAME, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_DESCRIPTION, (metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN()),
                    Neo4jConstants.PROPERTY_UID, fieldUid,
                    Neo4jConstants.PROPERTY_DATA_FIELD_FULL_PATH, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_NAMESPACE, nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(field)",
                    Neo4jConstants.RELATION_CREATES));

//            Neo4jManager.getNeo4jManager().ExecuteNoQuery(statementBuilder.toString());
            kgHelpService.executeCyhper(statementBuilder.toString(),new HashMap<>());
        } else {
            String entityUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID, tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null",
                        Neo4jConstants.LABEL_ACTION, Neo4jConstants.PROPERTY_ACTION_ID, actionId, Neo4jConstants.PROPERTY_NAMESPACE, nameSpace, Neo4jConstants.PROPERTY_ESP_ACTION_TENANT_ID));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (entity:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\"})",
                    Neo4jConstants.LABEL_DATA_ENTITY,
                    Neo4jConstants.PROPERTY_NAME, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_DESCRIPTION, (metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN()),
                    Neo4jConstants.PROPERTY_UID, entityUid,
                    Neo4jConstants.PROPERTY_DATA_FIELD_FULL_PATH, metadata.getData_name(),
                    Neo4jConstants.PROPERTY_NAMESPACE, nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(entity)",
                    Neo4jConstants.RELATION_CREATES));

//            Neo4jManager.getNeo4jManager().ExecuteNoQuery(statementBuilder.toString());
            kgHelpService.executeCyhper(statementBuilder.toString(),new HashMap<>());

            if (metadata.getField() == null || metadata.getField().size() == 0) {
                return;
            }
            for (ApiDataFieldMetadataDTO fieldDTO : metadata.getField()) {
                if (fieldDTO.getData_type().equals("object")) {
                    CreateDetailEntity(fieldDTO, entityUid, metadata.getData_name(), false, actionId, nameSpace);
                } else {
                    CreateParameterField(fieldDTO, entityUid, metadata.getData_name(), false, actionId, nameSpace);
                }
            }
        }
    }

    private void CreateDetailEntity(ApiDataFieldMetadataDTO metadata, String parentEntityUid, String path, boolean isRequest, String actionId, String nameSpace) {
        if (!metadata.getData_type().equals("object")) {
            return;
        }
        String entityUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");

        StringBuffer statementBuilder = new StringBuffer();
        statementBuilder.append(String.format("match (parentEntity:%s) where parentEntity.%s=\"%s\"",
                Neo4jConstants.LABEL_DATA_ENTITY, Neo4jConstants.PROPERTY_UID, parentEntityUid));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (entity:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})",
                Neo4jConstants.LABEL_DATA_ENTITY,
                Neo4jConstants.PROPERTY_NAME, metadata.getData_name(),
                Neo4jConstants.PROPERTY_DESCRIPTION, (metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN()),
                Neo4jConstants.PROPERTY_UID, entityUid,
                Neo4jConstants.PROPERTY_DATA_FIELD_FULL_PATH, path + "." + metadata.getData_name(),
                Neo4jConstants.PROPERTY_NAMESPACE, nameSpace));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (parentEntity)-[:%s]->(entity)",
                Neo4jConstants.RELATION_CONTAINS));

//        Neo4jManager.getNeo4jManager().ExecuteNoQuery(statementBuilder.toString());
        kgHelpService.executeCyhper(statementBuilder.toString(),new HashMap<>());
        if (metadata.getField() == null || metadata.getField().size() == 0) {
            return;
        }
        for (ApiDataFieldMetadataDTO fieldDTO : metadata.getField()) {
            if (fieldDTO.getData_type().equals("object")) {
                CreateDetailEntity(fieldDTO, entityUid, path + "." + metadata.getData_name(), isRequest, actionId, nameSpace);
            } else {
                CreateParameterField(fieldDTO, entityUid, path + "." + metadata.getData_name(), isRequest, actionId, nameSpace);
            }
        }
    }

    private void CreateParameterField(ApiDataFieldMetadataDTO metadata, String entityId, String path, boolean isRequest, String actionId, String nameSpace) {
        String fieldUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");

        StringBuffer statementBuilder = new StringBuffer();
        statementBuilder.append(String.format("match (entity:%s) where entity.%s=\"%s\"",
                Neo4jConstants.LABEL_DATA_ENTITY, Neo4jConstants.PROPERTY_UID, entityId));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (field:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})",
                Neo4jConstants.LABEL_DATA_FIELD,
                Neo4jConstants.PROPERTY_NAME, metadata.getData_name(),
                Neo4jConstants.PROPERTY_DESCRIPTION, (metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN()),
                Neo4jConstants.PROPERTY_UID, fieldUid,
                Neo4jConstants.PROPERTY_DATA_FIELD_FULL_PATH, path + "." + metadata.getData_name(), //冗余全路径，避免DataPulling时每次还要检索拼接路径
                Neo4jConstants.PROPERTY_DATA_TYPE, metadata.getData_type(),
                Neo4jConstants.PROPERTY_NAMESPACE, nameSpace));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (entity)-[:%s]->(field)",
                Neo4jConstants.RELATION_CONTAINS));
//        Neo4jManager.getNeo4jManager().ExecuteNoQuery(statementBuilder.toString());
        kgHelpService.executeCyhper(statementBuilder.toString(),new HashMap<>());
    }

    private void CreateFieldMap() {
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(a:EspAction)-[:Requires]->(ae:DataEntity)-[:Contains*0..3]->(ad:DataField) match(b:EspAction)-[:Creates]->(be:DataEntity)-[:Contains*0..3]->(bd:DataField) where ad.fullPath=bd.fullPath and id(a)<>id(b) merge (ad)-[:MapsTo]->(bd)");
    }
}
