package com.digiwin.athena.knowledgegraph.rule;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleDTO;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleTemplateDO;

/***
 * 后续新增侦测类型只需要继承此类，进行对应的子类实现即可
 * @author Alor
 *
 */
public abstract class AbstractMonitorRuleCategoryService {
    public abstract MonitorRuleCategoryEnum monitorRuleCategory();

    /***
     * 条件匹配
     * @param category
     * @return
     */
    public boolean support(MonitorRuleCategoryEnum category) {
        return monitorRuleCategory() == category;
    }

    /***
     * 业务逻辑处理
     * @param ruleDTO
     *        侦测对象
     * @param productConfig
     *       侦测【产品相关配置】
     * @param templateDO
     *       侦测模版【侦测的定义】
     * @param tenantConfig
     *       侦测组户级别的配置
     */
    public abstract void execute(MonitorRuleDTO ruleDTO,
                                 MonitorRuleProductConfig productConfig,
                                 MonitorRuleTemplateDO templateDO,
                                 MonitorRuleTenantConfig tenantConfig) throws DWBusinessException;

}
