package com.digiwin.athena.knowledgegraph.rule.dao;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository
public class MonitorRuleProductConfigDAO extends MongoEntityBaseDAO {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplate;

    public MonitorRuleProductConfig findProductConfigByRuleIdAndProductName(String ruleId, String productName, String tenantVersion) throws DWBusinessException {

        Map<String, Object> conditions = new HashMap<>();
        conditions.put(MonitorRuleManager.MONITOR_RULE_ID_FIELD, ruleId);
        conditions.put(MonitorRuleManager.PRODUCT_NAME_FIELD,productName);
        MonitorRuleProductConfig result = super.findOne(conditions, tenantVersion, MonitorRuleProductConfig.class);
        if (result != null) {
            return result;
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.noAvailableConfiguration",ruleId,productName));
        }
    }
}
