package com.digiwin.athena.knowledgegraph.rule.model;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.product.ActionParamConfigDO;
import com.digiwin.athena.kg.monitorRule.product.ActionParamTypeEnum;
import com.digiwin.athena.kg.monitorRule.product.FuncParamConfigDO;

import java.util.ArrayList;
import java.util.List;

public class FunctionActionParamDTO extends ActionParamDTO {
    private List<FunctionParamDTO> function_params;
    private String func_name;

    public List<FunctionParamDTO> getFunction_params() {
        return function_params;
    }

    public void setFunction_params(List<FunctionParamDTO> function_params) {
        this.function_params = function_params;
    }

    public String getFunc_name() {
        return func_name;
    }

    public void setFunc_name(String func_name) {
        this.func_name = func_name;
    }

    public static FunctionActionParamDTO parseFromDO(ActionParamConfigDO configDO) throws DWBusinessException {
        if (configDO.getType() != ActionParamTypeEnum.FUNCTION) {
            throw new DWBusinessException("Cannot parse from config to FunctionActionParamDTO");
        }
        FunctionActionParamDTO paramDTO = new FunctionActionParamDTO();
        paramDTO.setName(configDO.getName());
        paramDTO.setType(configDO.getType());
        paramDTO.setFunc_name(configDO.getFuncName());
        List<FunctionParamDTO> funcParamDTO = new ArrayList<FunctionParamDTO>();
        for (FuncParamConfigDO funcParamDO : configDO.getFunctionParams()) {
            funcParamDTO.add(new FunctionParamDTO(funcParamDO.getType(), funcParamDO.getValue()));
        }
        paramDTO.setFunction_params(funcParamDTO);
        return paramDTO;
    }
}
