package com.digiwin.athena.knowledgegraph.rule.parameter;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import com.digiwin.athena.kg.monitorRule.StandardPollingRuleDesign;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.enums.TimeTypeEnum;
import com.digiwin.athena.knowledgegraph.po.PhPMechanismApiCommonConfig;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleMechanismParameterService;
import com.digiwin.athena.knowledgegraph.rule.model.parameter.MechanismParameterReqDO;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
@MyExceptionHandler
public class CheckFrequencyMechanismParameterService extends
        AbstractMonitorRuleMechanismParameterService<MechanismParameterReqDO, TriggerDTO> {
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    private MechanismService mechanismService;

    @Override
    public boolean accept(String code) {
        Query query = Query.query(Criteria.where("code").is(Constants.ApiAction.code));
        PhPMechanismApiCommonConfig phPMechanismApiCommonConfig = mongoTemplateSystem.findOne(query, PhPMechanismApiCommonConfig.class);
        if (!Objects.isNull(phPMechanismApiCommonConfig)) {
            return null != code && code.endsWith(phPMechanismApiCommonConfig.getPhp_task_overdue_warning_param_code());
        }
        return false;
    }

    @Override
    public TriggerDTO parse(MechanismParameterReqDO mechanismParameterReqDO) {
        try {
            Query query = Query.query(Criteria.where("code").is(Constants.ApiAction.code));
            PhPMechanismApiCommonConfig phPMechanismApiCommonConfig = mongoTemplateSystem.findOne(query, PhPMechanismApiCommonConfig.class);
            Map<String, Object> map = (Map<String, Object>) this.mechanismService.getVariable(mechanismParameterReqDO.getVariableCode(), mechanismParameterReqDO.getTenantId());
            Object o = map.get(mechanismParameterReqDO.getVariableCode());
            if (o instanceof String) {
                TimeTypeEnum timeTypeEnum = TimeTypeEnum.adapt(String.valueOf(o));
                StandardPollingRuleDesign standardPollingRuleDesign = new StandardPollingRuleDesign();
                standardPollingRuleDesign.setInterval(timeTypeEnum.getInterval());
                standardPollingRuleDesign.setTimeType(timeTypeEnum.getValue());
                standardPollingRuleDesign.setStartTime(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                if (!Objects.isNull(phPMechanismApiCommonConfig)
                        &&StringUtils.isNotBlank(phPMechanismApiCommonConfig.getPhp_task_overdue_warning_time())) {
                    standardPollingRuleDesign.setTimeValue(timeTypeEnum.getTimeValue() + phPMechanismApiCommonConfig.getPhp_task_overdue_warning_time());
                }else{
                    standardPollingRuleDesign.setTimeValue(timeTypeEnum.getTimeValue() + timeTypeEnum.getTimeValueFixedValue());
                }
                StandardPollingRule standardPollingRule = standardPollingRuleDesign.toStandardPollingRule();
                return JsonUtil.toObject(JsonUtil.toJsonString(standardPollingRule), TriggerDTO.class);
            }
        } catch (DWBusinessException e) {
            log.error("knowledgegraph,getVariable 异常{},{}", mechanismParameterReqDO.getVariableCode(), e);
        }
        return null;
    }
}
