package com.digiwin.athena.knowledgegraph.service;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.dap.DapResponseBase;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class AppMetaCaller {

    @Value("${dataMapUrl}")
    private String dataMapUrl;
    private String kgHost=null;


    public static void main(String[] args) {
        TenantEntity entity1 = new TenantEntity();
        entity1.setId("id1");
        entity1.setTenantId("tenant001");
        DapResponse<TenantEntity> d1 = new DapResponse<>();
        d1.setDuration(100);
        d1.setResponse(entity1);
        String str = JSON.toJSONString(d1);
        System.out.println(str);

        DapResponse<TenantEntity> d2 = JSON.parseObject(str,DapResponse.class);
        TenantEntity i1 = d2.getResponse();
        System.out.println(i1);
        System.out.println(i1.getClass());
    }

    public static Map<String,Object> of(String k,Object v){
        Map<String,Object> map = new HashMap<>();
        map.put(k,v);
        return map;
    }


//
//    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
//    public Object getTaskName(String taskCode){
//        Map<String,Object> params = new HashMap<>();
//        params.put("code",taskCode);
//        DapResponse resp = requestDataMap("/task/taskByCode","get",params);
//        return resp.getResponse();
//    }
//
//
//    public Object getPageUIElement(String code, String activityId, String pageCode) {
//        Map<String, Object> params = new HashMap<>();
//        params.put("code", code);
//        params.put("taskCode", activityId);
//        params.put("pageCode", pageCode);
//        DapResponse resp = requestDataMap("/view/pageUIElement", "post", params);
//        return resp.getResponse();
//    }






    public  <T extends DapResponseBase> T call(String service, String httpMethod, Map<String, Object> params, Class<T> c) {

        T result = null;
        try {
            String url = dataMapUrl+"/restful/standard/datamap"+ service;
            Map<String,String> headers = new HashMap<>();
            if(null==kgHost){
                try {
                    URL u = new URL(dataMapUrl);
                    kgHost = u.getHost();
                } catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host",kgHost);
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            // StatementService 迁移入datamap中，有方法使用了header中的reportKey，因此需要取出重新设置入header中
            String reportKey = request.getHeader("reportKey");
            if(null==token){
                token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if(null==token){
                LoginInfo loginInfo = KgFilter.getLoginInfo();
                if(null!=loginInfo){
                    token = loginInfo.getToken();
                    routerKey=loginInfo.getRouterKey();
                    locale = loginInfo.getLocale();
                    designer = loginInfo.getDesigner();
                }
            }
            if (null!=routerKey) {
                headers.put("routerKey", routerKey);
            }
            if(null!=token){
                headers.put("token", token);
            }
            if(null!=locale){
                headers.put("locale", locale);
            }
            if(null!=designer){
                headers.put("designer", designer);
            }
            if(null!=securityToken){
                headers.put("security-token", securityToken);
            }
            if(null!=reportKey){
                headers.put("reportKey", reportKey);
            }
            if("post".equalsIgnoreCase(httpMethod)){
                result= Utils.postJson(url,headers,params,c);
            }else{
                result= Utils.get(url,headers,params,c);
            }
        }catch (Exception e){
            if(e instanceof IOException) {throw new RemoteAccessException("io异常");}
            //安静的吃掉异常
            log.warn("request to datamap failed.", e);

        }
        if(null==result){
            try {
                return c.newInstance();
            } catch (InstantiationException e) {
                throw new RuntimeException(e);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if(result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502
                || result.getStatus() == 400) {
            log.error("request to datamap failed, status:{}", result.getErrorMessage());
            throw new DWRuntimeException("P.KG.503.0017", "call datamap error");
        }

        return result;

    }

    public DapResponse requestDataMap(String service, String httpMethod, Map<String,Object> params, String routerKey){

        DapResponse result = new DapResponse();
        try {
            String url = dataMapUrl+"/restful/standard/datamap"+ service;
            Map<String,String> headers = new HashMap<>();
            if(null==kgHost){
                try {
                    URL u = new URL(dataMapUrl);
                    kgHost = u.getHost();
                } catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host",kgHost);
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            if(StringUtils.isEmpty(routerKey)){
                routerKey = request.getHeader("routerKey");
            }
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            // StatementService 迁移入datamap中，有方法使用了header中的reportKey，因此需要取出重新设置入header中
            String reportKey = request.getHeader("reportKey");
            if(null==token){
                token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null!=routerKey) {
                headers.put("routerKey", routerKey);
            }
            if(null!=token){
                headers.put("token", token);
            }
            if(null!=locale){
                headers.put("locale", locale);
            }
            if(null!=designer){
                headers.put("designer", designer);
            }
            if(null!=securityToken){
                headers.put("security-token", securityToken);
            }
            if(null!=reportKey){
                headers.put("reportKey", reportKey);
            }
            if("post".equalsIgnoreCase(httpMethod)){
                result= Utils.postJson(url,headers,params,DapResponse.class);
            }else{
                result= Utils.get(url,headers,params,DapResponse.class);
            }
        }catch (Exception e){
            //安静的吃掉异常
            log.warn("request to datamap failed,"+e.getMessage());
        }
        if(null==result){
            return new DapResponse();
        }

        return result;

    }



    public DapResponse requestDataMapAnonymous(String service, String httpMethod, Map<String, Object> params) {

        DapResponse result = new DapResponse();
        try {
            String url = dataMapUrl+"/restful/standard/datamap"+ service;
            Map<String,String> headers = new HashMap<>();
            if(null==kgHost){
                try {
                    URL u = new URL(dataMapUrl);
                    kgHost = u.getHost();
                } catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host",kgHost);
            //此处try catch不要去了
            try {
                HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                String routerKey = request.getHeader("routerKey");


                if (null!=routerKey) {
                    headers.put("routerKey", routerKey);
                }
            } catch (Exception e) {
                log.warn("requestDataMapAnonymous get request null");
            }

            if("post".equalsIgnoreCase(httpMethod)){
                result= Utils.postJson(url,headers,params,DapResponse.class);
            }else{
                result= Utils.get(url,headers,params,DapResponse.class);
            }
        }catch (Exception e){
            //安静的吃掉异常
            log.error("request to datamap anonymous failed.", e);

        }
        if(null==result){
            return new DapResponse();
        }
        if(result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502){
            throw new DWRuntimeException("P.KG.503.0017", "anonymous call datamap error");
        }

        return result;

    }


}
