package com.digiwin.athena.knowledgegraph.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.task.EmailView;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.ViewRequest;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldRequest;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldVO;
import com.digiwin.athena.preset.Rule;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
@Slf4j
public class DataMapService{

    @Value("${dataMapUrl}")
    private String dataMapUrl;
    private String kgHost=null;

    WebClient webClient;

    @Autowired
    private IamService iamService;

    @Autowired
    RestTemplate restTemplate;


    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getProject(String code, OperationUnit eocInfo){
        Map<String,Object> params = new HashMap<>();
        params.put("projectCode",code);
        params.put("eocInfo",eocInfo);
        DapResponse resp = requestDataMap("/view/project","post",params);
        return resp.getResponse();
    }

    /**
     * 查询pageView中taskCardField字段里的值
     * @param request
     * @return
     * @throws DWException
     */
    public List<TaskCardFieldVO> postViewTaskCardField(TaskCardFieldRequest request) {
        DapResponse dapResponse = requestDataMap("/view/taskCardField", "post", JSON.parseObject(JSON.toJSONString(request)));
        Object response = dapResponse.getResponse();
        return JSON.parseArray(JSON.toJSONString(response),TaskCardFieldVO.class);
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getAppCardFields(String application){
        Map<String,Object> params = new HashMap<>();
        params.put("application", application);
        DapResponse resp = requestDataMap("/view/appCardFields","post",params);
        return resp.getResponse();
    }

    /**
     * 根据项目code设置完成时间
     * @param code 项目code
     * @return
     */
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object postFixProject(String code){
        Map<String,Object> params = new HashMap<>();
        params.put("code",code);
        DapResponse resp = requestDataMap("/project/fixProjectByCode","post",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getProject(String code){
        Map<String,Object> params = new HashMap<>();
        params.put("projectCode",code);
        DapResponse resp = requestDataMap("/view/project","post",params);
        return resp.getResponse();
    }
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object geMonitorConfig(String dataEventId){
        Map<String,Object> params = new HashMap<>();
        params.put("id",dataEventId);
        DapResponse resp = requestDataMap("/project/monitorConfig","get",params);
        return resp.getResponse();
    }
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List getProjectsBasic(Map<String,Object> query){
        Map<String,Object> params = new HashMap<>();
        params.put("query",query);
        DapResponse<List> resp = requestDataMap("/view/projectListBasic","post",params);
        return resp.getResponse();
    }
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getBatchProjects(Map<String,Object> query){
        Map<String,Object> params = new HashMap<>();
        params.put("query",query);
        DapResponse<Object> resp = requestDataMap("/batch/projects","post",params);
        return resp.getResponse();
    }


    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List getProjectsByAuthorityPrefix(String authorityPrefix){
        Map<String,Object> params = new HashMap<>();
        params.put("authorityPrefix",authorityPrefix);
        DapResponse<List> resp = requestDataMap("/project/projectByAuthorityPrefix","get",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getBatchTasks(Map<String,Object> query){
        Map<String,Object> params = new HashMap<>();
        params.put("query",query);
        DapResponse<Object> resp = requestDataMap("/batch/tasks","post",params);
        return resp.getResponse();
    }

    /**
     * 根据条件查询项目，包含pageView视图数据，项目任务目标，里程碑
     * @param query 查询条件
     * @return
     */
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List getProjects(Map<String,Object> query){
        Map<String,Object> params = new HashMap<>();
        params.put("query",query);
        DapResponse<List> resp = requestDataMap("/view/projectList","post",params);
        return resp.getResponse();
    }
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List getTaskList(Map<String,Object> query){
        Map<String,Object> params = new HashMap<>();
        params.put("query",query);
        DapResponse<List> resp = requestDataMap("/view/taskList","post",params);
        return resp.getResponse();
    }
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getTasks(String code){
        Map<String,Object> params = new HashMap<>();
        params.put("projectCode",code);
        DapResponse resp = requestDataMap("/view/tasks","post",params);
        return resp.getResponse();
    }
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getTask(String projectCode,String taskCode,String pageCode){
        Map<String,Object> params = new HashMap<>();
        params.put("projectCode",projectCode);
        params.put("taskCode",taskCode);
        params.put("pageCode",pageCode);
        DapResponse resp = requestDataMap("/view/task","post",params);
        return resp.getResponse();
    }

    /**
     * 根据条件查询任务
     * @param projectCode 项目code
     * @param taskCode 任务code
     * @param pageCode 页面类型code
     * @param operationUnit 运营单元
     * @return 返回数据
     */
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getTask(String projectCode,String taskCode,String pageCode,OperationUnit operationUnit){
        Map<String,Object> params = new HashMap<>();
        params.put("projectCode",projectCode);
        params.put("taskCode",taskCode);
        params.put("pageCode",pageCode);
        params.put("eocInfo",operationUnit);
        DapResponse resp = requestDataMap("/view/task","post",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List getCodeNames(List<String> codes,boolean isTask){
        Map<String,Object> params = new HashMap<>();
        Map<String,Object> query = new HashMap<>();
        query.put("code",codes);
        params.put("query",query);
        String url = isTask?"/view/taskNamesByCodes":"/view/projectNamesByCodes";
        DapResponse<List> resp =  requestDataMap(url,"post",params);
        return resp.getResponse();
    }


    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object getTaskName(String taskCode){
        Map<String,Object> params = new HashMap<>();
        params.put("code",taskCode);
        DapResponse resp = requestDataMap("/task/taskByCode","get",params);
        return resp.getResponse();
    }

    public Object initTenantInfo(String tenantId,String application, String routerKey){
        return initTenantInfo(tenantId, application, routerKey, null);
    }

    public Object initTenantInfo(String tenantId,String application, String routerKey, String appCode){
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId",tenantId);
        params.put("application",application);
        params.put("appCode",appCode);
        DapResponse resp = requestDataMap("/tenant/init","post",params, routerKey);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List approveTaskList(Map<String,Object> query){
        Map<String,Object> params = new HashMap<>();
        params.put("query",query);
        DapResponse<List> resp = requestDataMap("/view/taskListApprove","post",params);
        return resp.getResponse();
    }

    public void updateProject(Object pro){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(pro));
        requestDataMap("/view/updateProject","post",params);
    }

    public void updateProject(Object pro, OperationUnit operationUnit){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(pro));
        params.put("eocInfo", JSON.parseObject(JSON.toJSONString(operationUnit)));
        requestDataMap("/view/updateProject","post",params);
    }

    public void updateTask(Object pro){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(pro));
        requestDataMap("/view/updateTask","post",params);
    }

    public void updateTaskScheduleFlag(Object pro){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(pro));
        requestDataMap("/view/updateTaskScheduleFlag","post",params);
    }

    public void postTaskSchedule(Object pro){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(pro));
        requestDataMap("/view/taskSchedule","post",params);
    }

    public void postDeleteTaskSchedule(Object pro){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(pro));
        requestDataMap("/view/deleteTaskSchedule","post",params);
    }

    public void updateTask(Object pro, OperationUnit operationUnit){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(pro));
        params.put("eocInfo", JSON.parseObject(JSON.toJSONString(operationUnit)));
        requestDataMap("/view/updateTask","post",params);
    }


    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List getProjectTasks(String projectCode){
        Map<String,Object> params = new HashMap<>();
        params.put("projectCode",projectCode);
        DapResponse<List> resp = requestDataMap("/view/projectTasks","post",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List batchProjects(List<String> codes){
        Map<String,Object> params = new HashMap<>();
        params.put("codes",codes);
        DapResponse<List> resp = requestDataMap("/batch/projectBasic","post",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object batchTaskDetails(Set<String> codes, String pageCode,OperationUnit operationUnit){
        Map<String,Object> params = new HashMap<>();
        params.put("codes",codes);
        params.put("pageCode",pageCode);
        params.put("eocInfo",operationUnit);
        DapResponse resp = requestDataMap("/batch/taskDetails","post",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List batchTasks(List<String> codes){
        Map<String,Object> params = new HashMap<>();
        params.put("codes",codes);
        DapResponse<List> resp = requestDataMap("/batch/taskBasic","post",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List postEmails(ViewRequest request){
        Map<String,Object> params = new HashMap<>();
        params.put("taskCode",request.getTaskCode());
        DapResponse<List> resp = requestDataMap("/email/emails","post",params);
        return resp.getResponse();
    }
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List postTasksByProject(Map<String,Object> params){
        DapResponse<List> resp = requestDataMap("/view/tasksByProject","post",params);
        return resp.getResponse();
    }

    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object postEmailTemplateCode(ViewRequest request){
        Map<String,Object> params = new HashMap<>();
        params.put("taskCode",request.getTaskCode());
        DapResponse resp = requestDataMap("/email/emailTemplateCode","post",params);
        return resp.getResponse();
    }

    public List postEmailUpdate(EmailView view){
        Map<String,Object> params = JSON.parseObject(JSON.toJSONString(view));
        DapResponse<List> resp = requestDataMap("/email/emailUpdate","post",params);
        return resp.getResponse();
    }

    /**
     * 根据项目code和任务code获取发起当前签核任务的任务code
     * @param query
     * @return
     */
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object postActivityStartTargetCode(Map<String,Object> query){
        DapResponse resp = requestDataMap("/view/activityStartTargetCode","post",query);
        return resp.getResponse();
    }

    /**
     * 根据项目code获取输入流
     * @param code 项目code
     * @return
     */
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object projectInputData(String code){
        Map<String,Object> params = new HashMap<>();
        params.put("projectCode",code);
        DapResponse resp = requestDataMap("/view/projectInputData","post",params);
        return resp.getResponse();
    }

    /**
     * 根据任务code获取输入流
     * @param code 任务code
     * @return
     */
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object taskInputData(String code){
        Map<String,Object> params = new HashMap<>();
        params.put("taskCode",code);
        DapResponse resp = requestDataMap("/view/taskInputData","post",params);
        return resp.getResponse();
    }

    @Retryable(value = {RemoteAccessException.class}, maxAttempts = 5, backoff = @Backoff(delay = 50l, multiplier = 2))
    public List projectExcludeMainlineByAppCode(String appCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("appCode", appCode);
        DapResponse<List> resp = requestDataMap("/business/projectExcludeMainlineByAppCode", "post", params);
        return resp.getResponse();
    }

    public Object enableTenantServiceCapability(String code){
        return updateTenantServiceCapabilityStatus(code, 0);
    }

    public Object disableTenantServiceCapability(String code){
        return updateTenantServiceCapabilityStatus(code, 1);

    }

    private Object updateTenantServiceCapabilityStatus(String code, int status) {
        Map<String,Object> params = new HashMap<>();
        params.put("scCode",code);
        params.put("status", status);
        DapResponse resp = requestDataMap("/word/UpdateTenantServiceCapabilityStatus","post",params);
        return resp.getResponse();
    }

    public Object bindMechanismDecision(String tenantId, String mechanismCode, String mechanismTheoryCode, String mechanismComponentCode) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId",tenantId);
        params.put("mechanismCode", mechanismCode);
        params.put("mechanismTheoryCode", mechanismTheoryCode);
        params.put("mechanismComponentCode", mechanismComponentCode);
        DapResponse resp = requestDataMap("/mechanism/bindMechanism","post",params);
        return resp.getResponse();
    }

    public Object unbindMechanismDecision(String tenantId, String mechanismCode, String mechanismTheoryCode, String mechanismComponentCode) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId",tenantId);
        params.put("mechanismCode", mechanismCode);
        params.put("mechanismTheoryCode", mechanismTheoryCode);
        params.put("mechanismComponentCode", mechanismComponentCode);
        DapResponse resp = requestDataMap("/mechanism/unBindMechanism","post",params);
        return resp.getResponse();
    }

    public Object mechanismPluginMerge(String tenantId, List<String> pluginIds) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId",tenantId);
        params.put("pluginIds", pluginIds);
        DapResponse resp = requestDataMap("/plugin/merge","post",params);
        return resp.getResponse();
    }

    public DapResponse bindMechanismComponent(Map<String,Object> query) {
        DapResponse resp = requestDataMap("/mechanism/componentApply", "post", query);
        return resp;
    }

    public DapResponse unBindMechanismComponent(Map<String,Object> query) {

        DapResponse resp= requestDataMap("/mechanism/componentUnApply","post",query);
        return resp;
    }

    public DapResponse filterListByBusinessCondition(Map<String,Object> query) {
        DapResponse resp = requestDataMap("/mechanism/filterListByBusinessCondition", "post", query);
        return resp;
    }

    public void unBindMechanismComponentWithTenantId(Map<String,Object> query, String tenantId) throws IOException {
        String url = dataMapUrl+ "/restful/standard/datamap/mechanism/componentUnApply";
        Map<String,String> headers = new HashMap<>();
        if(null==kgHost){
            URL u = new URL(dataMapUrl);
            kgHost = u.getHost();
        }
        headers.put("Host",kgHost);
        headers.put("routerKey", tenantId);
        headers.put("token", iamService.getIntegrationToken(tenantId, null));
        DapResponse result= Utils.postJson(url,headers,query,DapResponse.class);
        if(result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502){
            throw new DWRuntimeException("P.KG.503.0017", "call datamap error");
        }
    }

   // @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List postCardConfig(Map<String,Object> query,String pageCode){
        Map<String,Object> params = new HashMap<>();
        params.put("pageCode",pageCode);
        params.put("query",query);
        DapResponse<List> resp = requestDataMap("/view/cardConfig","post",params);
        return resp.getResponse();
    }

    // @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public List postCardConfig(Map<String, Object> query) {
        Map<String, Object> params = new HashMap<>();
        params.put("query", query);
        DapResponse<List> resp = requestDataMap("/view/cardConfig", "post", params);
        return resp.getResponse();
    }

    public List postCardConfig4Order(Map<String, Object> query) {
        Map<String, Object> params = new HashMap<>();
        params.put("query", query);
        params.put("type", "all");
        DapResponse<List> resp = requestDataMap("/view/cardConfig", "post", params);
        return resp.getResponse();
    }

    public Object getPageUIElement(String code, String activityId, String pageCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("code", code);
        params.put("taskCode", activityId);
        params.put("pageCode", pageCode);
        DapResponse resp = requestDataMap("/view/pageUIElement", "post", params);
        return resp.getResponse();
    }

    public Object getSystemHooks(List<String> activityIds, List<String> pageCodes) {
        Map<String, Object> params = new HashMap<>();
        params.put("taskCodes", activityIds);
        params.put("pageCodes", pageCodes);
        DapResponse resp = requestDataMap("/view/systemHooks", "post", params);
        return resp.getResponse();
    }
    public Object postQueryApiResult(String api, Map<String, Object> params) {
        DapResponse<List> resp = requestDataMap(api, "post", params);
        return resp.getResponse();
    }


    public Object queryBatchCodeAndName(List<String> codes, String type, String version){
        Map<String,Object> params = new HashMap<>();
        params.put("codes",codes);
        params.put("type",type);
        params.put("version",version);
        //注意此处用的是requestDataMapAnonymous 不是 requestDataMap
        DapResponse<Object> resp = requestDataMapAnonymous("/batch/queryCodeAndName","post",params);
        return resp.getResponse();
    }



    public DapResponse requestDataMap(String service, String httpMethod, Map<String, Object> params) {
        String url = dataMapUrl +"/restful/standard/datamap"+ service;
        HttpMethod method = HttpMethod.POST;
        if("get".equalsIgnoreCase(httpMethod)){
            method = HttpMethod.GET;
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(url);
            if (params != null && !params.isEmpty()) {
                params.forEach(builder::queryParam);
            }
            url = builder.toUriString();
        }
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders(headers);
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(params,headers);
        ResponseEntity<DapResponse> exchange = restTemplate.exchange(url, method, httpEntity, DapResponse.class);
        return exchange.getBody();
    }

    public DapResponse requestDataMap2(String service, String httpMethod, Map<String, Object> params) {

        DapResponse result = new DapResponse();
        try {
            String url = dataMapUrl+"/restful/standard/datamap"+ service;
            Map<String,String> headers = new HashMap<>();
            if(null==kgHost){
                try {
                    URL u = new URL(dataMapUrl);
                    kgHost = u.getHost();
                } catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host",kgHost);
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            if(null==token){
                token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if(null==token){
                LoginInfo loginInfo = KgFilter.getLoginInfo();
                if(null!=loginInfo){
                    token = loginInfo.getToken();
                    routerKey=loginInfo.getRouterKey();
                    locale = loginInfo.getLocale();
                    designer = loginInfo.getDesigner();
                }
            }
            if (null!=routerKey) {
                headers.put("routerKey", routerKey);
            }
            if(null!=token){
                headers.put("token", token);
            }
            if(null!=locale){
                headers.put("locale", locale);
            }
            if(null!=designer){
                headers.put("designer", designer);
            }
            if(null!=securityToken){
                headers.put("security-token", securityToken);
            }
            if("post".equalsIgnoreCase(httpMethod)){
                result= Utils.postJson(url,headers,params,DapResponse.class);
            }else{
                result= Utils.get(url,headers,params,DapResponse.class);
            }
        }catch (Exception e){
            if(e instanceof IOException) {throw new RemoteAccessException("io异常");}
            //安静的吃掉异常
            log.warn("request to datamap failed.", e);

        }
        if(null==result){
            return new DapResponse();
        }
        if(result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502
                || result.getStatus() == 400) {
            log.error("request to datamap failed, status:{}", result.getErrorMessage());
            throw new DWRuntimeException("P.KG.503.0017", "call datamap error uri:"+service+",msg:"+result.getErrorMessage());
        }

        return result;

    }

    public DapResponse requestDataMap(String service, String httpMethod, Map<String,Object> params, String routerKey){

        DapResponse result = new DapResponse();
        try {
            String url = dataMapUrl+"/restful/standard/datamap"+ service;
            Map<String,String> headers = new HashMap<>();
            if(null==kgHost){
                try {
                    URL u = new URL(dataMapUrl);
                    kgHost = u.getHost();
                } catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host",kgHost);
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            if(StringUtils.isEmpty(routerKey)){
                routerKey = request.getHeader("routerKey");
            }
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            if(null==token){
                token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null!=routerKey) {
                headers.put("routerKey", routerKey);
            }
            if(null!=token){
                headers.put("token", token);
            }
            if(null!=locale){
                headers.put("locale", locale);
            }
            if(null!=designer){
                headers.put("designer", designer);
            }
            if(null!=securityToken){
                headers.put("security-token", securityToken);
            }
            if("post".equalsIgnoreCase(httpMethod)){
                result= Utils.postJson(url,headers,params,DapResponse.class);
            }else{
                result= Utils.get(url,headers,params,DapResponse.class);
            }
        }catch (Exception e){
            //安静的吃掉异常
            log.warn("request to datamap failed,"+e.getMessage());
        }
        if(null==result){
            return new DapResponse();
        }

        return result;

    }


    public DapResponse requestDataMapAnonymous(String service, String httpMethod, Map<String, Object> params) {

        DapResponse result = new DapResponse();
        try {
            String url = dataMapUrl+"/restful/standard/datamap"+ service;
            Map<String,String> headers = new HashMap<>();
            if(null==kgHost){
                try {
                    URL u = new URL(dataMapUrl);
                    kgHost = u.getHost();
                } catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host",kgHost);
            //此处try catch不要去了
            try {
                HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                String routerKey = request.getHeader("routerKey");


                if (null!=routerKey) {
                    headers.put("routerKey", routerKey);
                }
            } catch (Exception e) {
                log.warn("requestDataMapAnonymous get request null");
            }

            if("post".equalsIgnoreCase(httpMethod)){
                result= Utils.postJson(url,headers,params,DapResponse.class);
            }else{
                result= Utils.get(url,headers,params,DapResponse.class);
            }
        }catch (Exception e){
            //安静的吃掉异常
            log.error("request to datamap anonymous failed.", e);

        }
        if(null==result){
            return new DapResponse();
        }
        if(result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502){
            throw new DWRuntimeException("P.KG.503.0017", "anonymous call datamap error");
        }

        return result;

    }


    public Object allApproveActivityByApp(String applicationCode, String locale) {
        Map<String, Object> params = new HashMap<>();
        params.put("applicationCode", applicationCode);
        params.put("locale", locale);
        DapResponse resp = requestDataMap("/activity/allApproveActivityByApp", "get", params);
        return resp.getResponse();
    }

    /**
     * 获取项目定义，含租户级配置
     *
     * @param taskId   项目定义编码
     * @param pageCode 页面类型了；例如：project-card
     * @return 返回项目定义
     */
    public Object getDefinitionWithMultiLanguage(String taskId, String pageCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("taskId", taskId);
        params.put("pageCode", pageCode);
        DapResponse resp = requestDataMap("/task/definitionWithMultiLanguage", "get", params);
        return resp.getResponse();
    }

    /**
     * 获取项目定义，含租户级配置
     *
     * @param taskId   项目定义编码
     * @return 返回项目定义
     */
    public Object getDefinitionByTaskId(String taskId) {
        Map<String, Object> params = new HashMap<>();
        params.put("taskId", taskId);
        DapResponse resp = requestDataMap("/task/definitionByTaskId", "get", params);
        return resp.getResponse();
    }

    /**
     * 根据项目编码和运营单元获取项目（pageView视图数据，项目任务目标，里程碑），过滤里程碑中无授权任务数据
     * @param query 查询条件 - 项目编码和运营单元
     * @return
     */
    public Object postDefinitionByTaskIdAndOperationUnit(Map<String,Object> query){
        DapResponse<Object> resp = requestDataMap("/task/definitionByTaskIdAndOperationUnit","post",query);
        return resp.getResponse();
    }

    /**
     * 根据任务code获取任务，包含页面设计数据和租户级配置数据
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @return 任务
     * @throws Exception
     */
    public Object getActivityDefinition(String activityId,String pageCode){
        Map<String,Object> params = new HashMap<>();
        params.put("activityId", activityId);
        params.put("pageCode", pageCode);
        DapResponse resp = requestDataMap("/task/activityDefinition","get",params);
        return resp.getResponse();
    }

    public Object getActivityDefinitionWithMergeRule(String taskId, String activityId, String pageCode) {
        Map<String,Object> params = new HashMap<>();
        params.put("taskId", taskId);
        params.put("activityId", activityId);
        params.put("pageCode", pageCode);
        DapResponse resp = requestDataMap("/task/activityDefinitionWithMergeRule","get",params);
        return resp.getResponse();
    }

    /**
     *
     * @param taskId
     * @param activityId
     * @return
     */
    public Object getActivityConfig(String taskId,String activityId){
        Map<String,Object> params = new HashMap<>();
        params.put("taskId",taskId);
        params.put("activityId",activityId);
        DapResponse resp = requestDataMap("/task/activityConfig","get",params);
        return resp.getResponse();
    }


    /**
     * 查询任务定义，包含任务流程和页面信息
     * @param query 查询条件
     * @return  任务定义信息
     */
    public Object postActivityDefinition(Map<String,Object> query){
        DapResponse<Object> resp = requestDataMap("/task/activityDefinition","post",query);
        return resp.getResponse();
    }

    public Object getManualList(){
        Map<String,Object> params = new HashMap<>();
        DapResponse resp = requestDataMap("/task/manualList","get",params);
        return resp.getResponse();
    }

    public Object getManualListMobile(){
        Map<String,Object> params = new HashMap<>();
        DapResponse resp = requestDataMap("/task/manualListMobile","get",params);
        return resp.getResponse();
    }

    public Object getDetail(String taskId){
        Map<String,Object> params = new HashMap<>();
        params.put("taskId",taskId);
        DapResponse resp = requestDataMap("/task/detail","get",params);
        return resp.getResponse();
    }

    public Object postTaskByApp(Map<String,Object> query){
        DapResponse<Object> resp = requestDataMap("/task/taskByApp","post",query);
        return resp.getResponse();
    }

    public Object postActivityByTask(Map<String,Object> params){
        DapResponse<List> resp = requestDataMap("/activity/activityByTask","post",params);
        return resp.getResponse();
    }


    /**
     * 按条件分页查询人工任务类型列表
     * @param query
     * @return
     */
    @Retryable(value= {RemoteAccessException.class},maxAttempts = 5,backoff = @Backoff(delay = 50l,multiplier = 2))
    public Object findTaskFromUser(Map<String,Object> query){
        DapResponse<Object> resp = requestDataMap("/task/findTaskFromUser","post",query);
        return resp.getResponse();
    }

    /**
     * 批量保存系统级的规则
     * @param rules 系统级的规则
     * @return Object
     */
    public Object saveRules(List<Rule> rules) {
        Map<String, Object> params = new HashMap<>();
        params.put("rules", rules);
        DapResponse resp = requestDataMap("/rule/batchSave", "post", params);
        return resp.getResponse();
    }
}
