package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.authority.AuthorityConfigVO;

/**
 * 权限服务
 * @javadoc
 **/
public interface IAuthorityService extends DWService {

    /**
     * 生成权限
     * @param config 权限配置
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postGenerateAuthority(AuthorityConfigVO config) throws Exception;

    /**
     * 生成基础数据权限
     * @param appCode 应用code
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postGenerateBasicDataAuthorityByAppCode(String appCode) throws Exception;

    /**
     * 生成基础数据权限
     * @param code 活动code
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postGenerateBasicDataAuthorityByCode(String code) throws Exception;

    @AllowAnonymous
    Object postStatementAuthorityByAppCode(String appCode) throws Exception;

    @AllowAnonymous
    Object postStatementAuthorityByCode(String code) throws Exception;

    @AllowAnonymous
    Object postStartProjectAuthorityByAppCode(String appCode) throws Exception;

    /**
     * 授权用户
     * @param config
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postGrantAuthorityToUser(AuthorityConfigVO config) throws Exception;

    /**
     * 2023S2临时接口，授权后，下个冲刺删除
     * @param config 权限配置
     * @return
     * @throws Exception
     */
    //TODO 2023S2临时接口，授权后，下个冲刺删除
    @AllowAnonymous
    Object postGrantGlobalMessageAuthorityToUser(AuthorityConfigVO config) throws Exception;

    /**
     * 2023S8 不同范式支持不同的基础资料入口-第二阶段 #14915
     * @param config 权限配置
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postTenantBasicDataByAppCodeAndId(AuthorityConfigVO config) throws Exception;
}
