package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.annotation.ScheduledCall;

import java.util.List;

/**
 * 组件服务
 * @javadoc
 */
public interface IComponentService extends DWService {
    /**
     * 根据应用code,范式code从系统级组件清单中获取系统级范式组件
     *
     * @param appCode  应用code
     * @param paradigm 范式code
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    @Deprecated
    Object getBaseFunctionComponentStructuredList(String appCode, String paradigm) throws Exception;

    /**
     * 根据应用code,范式code从系统级组件清单中获取系统级范式组件
     *
     * @param appCode  应用code
     * @param paradigm 范式code
     * @param version  版本号
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    Object getBaseFunctionComponentStructuredList(String appCode, String paradigm,String version) throws Exception;

    /**
     * 根据机制code从应用组件清单表中获取机制下组件数据
     * @param mechanismCode 机制code
     * @return
     * @throws Exception
     */
    Object getMechanismComponentStructuredList(String mechanismCode) throws Exception;

    /**
     * 根据应用code获取用户授权下的应用组件
     * @param appCode 应用code
     * @return
     * @throws DWBusinessException
     */
    Object getTenantApplicationComponentList(String appCode) throws DWBusinessException;

    /**
     * 初始化租户级组件清单
     * @param appCode 应用code
     * @param paradigm 范式code
     * @param mechanismCodes 租户带绑定机制code集合
     * @throws DWBusinessException
     */
    void postInitializeTenantApplicationComponentList(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException;

    /**
     * 初始化租户级组件清单
     * @param appCode 应用code
     * @param paradigms 范式code集合
     * @param mechanismCodes 租户带绑定机制code集合
     * @throws DWBusinessException
     */
    void postInitializeTenantApplicationComponentList(String appCode, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException;

    /**
     * 更新租户级组件清单
     * @param appCode 应用code
     * @param paradigm 范式code
     * @param mechanismCodes 租户带绑定机制code集合
     * @throws DWBusinessException
     */
    void postUpdateTenantApplicationComponentListByMechanism(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException;

    /**
     * 更新租户级组件清单
     * @param appCode 应用code
     * @param paradigms 范式code集合
     * @param mechanismCodes 租户带绑定机制code集合
     * @throws DWBusinessException
     */
    void postUpdateTenantApplicationComponentListByMechanism(String appCode, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException;

    /**
     * 初始化应用组件清单
     * @param appCode 应用code
     * @param paradigm 范式code
     * @param version 版本
     */
    void postInitializeApplicationComponentList(String appCode, String paradigm, String version) throws DWBusinessException;

    /**
     * 根据应用code和租户id获取组件数据
     * @param tenantId 租户id
     * @param appCode 应用code
     * @param eventType 通知类型
     * @param component 组件
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    @ScheduledCall
    Object postQueryComponent(String tenantId, String appCode, String eventType, List<String> component)  throws DWBusinessException ;

    /**
     * 根据应用code和租户信息清理租户机制组件数据和租户下范式机制数据
     * @param appCode 应用code
     * @param paradigm 范式code
     * @param mechanismCodes 机制code
     * @throws DWBusinessException
     */
    void postClearTenantApplicationComponentListByMechanism(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException;

    /**
     * 把应用新增的清单更新到租户组件清单中,如果数据库用应用组件清单不是最新的，也同步更新
     * @param appCode 应用编码
     * @param version 版本
     * @throws DWBusinessException 抛出异常
     */
    @AllowAnonymous
    void postUpdateApplicationComponentList(String appCode, String version) throws DWBusinessException;

    /**
     * 更新应用组件清单，个案版本包含租户ID，标准应用不包含
     * @param appCode 应用编码
     * @param tenantIds 租户ID集合
     * @param version 版本
     * @throws DWBusinessException 抛出异常
     */
    @AllowAnonymous
    void postUpdateApplicationComponentList(String appCode, List<String> tenantIds,String version) throws DWBusinessException;
}
