package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.QuerySubscriptionDTO;

import java.util.List;

/**
 * 数据订阅
 * @javadoc
 */
public interface IDataSubscriptionService extends DWService {
    /**
     * 保存订阅数据配置
     * @param config 配置信息
     * @return
     * @throws Exception
     */
    Object postAddDataSubscriptionConfig(DataSubscriptionRule config) throws Exception;

    /**
     * 查询数据订阅配置信息
     * @param tenantId 租户id
     * @param userId 用户id
     * @param question 查询条件
     * @param sceneCode 场景code
     * @return
     * @throws Exception
     */
    Object postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode) throws Exception;

    /**
     * 查询数据订阅配置信息-兼容指标订阅
     * @param tenantId 租户id
     * @param userId 用户id
     * @param question 查询条件
     * @param sceneCode 场景code
     * @param metricIdList 指标id
     * @return
     * @throws Exception
     */
    Object postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode, List<String> metricIdList) throws Exception;


    Object postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode, List<String> metricIdList,String asaCode) throws Exception;
    /**
     * 查询数据订阅配置信息-兼容敏数融合
     * @param tenantId 租户id
     * @param userId 用户id
     * @param question 查询条件
     * @param sceneCode 场景code
     * @param metricIdList 指标id
     * @param asaCode
     * @return
     * @throws Exception
     */
    Object postQueryDataSubscriptionConfig(String tenantId, String userId, String question,String sceneCode, List<String> metricIdList,List<String> datasetIdList,String asaCode) throws Exception;

    /**
     * 删除数据订阅配置信息
     * @param tenantId 租户id
     * @param userId 用户id
     * @param question 查询条件
     * @param sceneCode 场景code
     * @return
     */
    Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,String question);

    /**
     * 删除数据订阅配置信息-兼容指标订阅
     * @param tenantId 租户id
     * @param userId 用户id
     * @param question 查询条件
     * @param sceneCode 场景code
     * @param metricIdList 指标id
     * @return
     * @throws Exception
     */
    Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,List<String> metricIdList,String question);

    Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,List<String> metricIdList,String question,String asaCode);

    /**
     * 删除数据订阅配置信息-兼容敏数融合
     * @param tenantId 租户id
     * @param userId 用户id
     * @param question 查询条件
     * @param sceneCode 场景code
     * @param metricIdList 指标id
     * @param asaCode
     * @return
     * @throws Exception
     */
    Object postRemoveDataSubscriptionConfig(String tenantId,String userId,String sceneCode,List<String> metricIdList,List<String> datasetIdList,String question,String asaCode);

    /**
     * 根据租户id和规则删除数据订阅配置信息
     * @param tenantId 租户id
     * @param ruleIds 规则id集合
     * @return
     */
    Object postRemoveDataSubscriptionConfig(String tenantId,List<String> ruleIds);

    /**
     * 根据规则id获取单挑订阅数据
     * @param ruleId
     * @return
     * @throws Exception
     */
    Object getSingleDataSubscriptionConfig(String ruleId) throws Exception;

    /**
     * 续约批量恢复订阅 应用续约批量更新状态
     * @param config 配置信息
     */
    void postAppRenewDataSubscription(List<DataSubscriptionRule> config);

    /**
     *  批量删除订阅 应用过期批量删除 ,
     * @param config 配置信息
     * @param type 删除类型，update：软删除资料保留但是删除排程，delete：过了保留期删除
     */
    void postRemoveDataSubscription(List<DataSubscriptionRule> config,String type);

    /**
     * 保存订阅数据
     * @param ruleIds 规则id集合
     * @return
     */
    @AllowAnonymous
    Object postSegmentDataSubscription(List<String> ruleIds);

    Object postUpdateSubscriptionByConfig(QuerySubscriptionDTO config);
}
