package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.*;

import java.util.List;

/**
 * 决策树服务
 * @javadoc
 */
public interface IDecisionService extends DWService {

    Object postDecisionSchemesBatchByCodes(List<String> evlModelCodes) throws Exception;

    Object getDecisionModelsByApp(String appCode) throws Exception;

    Object getDecisionSchemesByCode(String evlModelCode) throws Exception;

    /**
     * 40762-辅助决策-DCP应用需求
     * 新增方法专为交付设计器调用
     * 根据决策模型code获取其下所有的系统级和租户级方案
     * @param evlModelCode
     * @return
     * @throws Exception
     */
    Object getDecisionSchemesByCodeForWeb(String evlModelCode) throws Exception;

    Object postDecisionModel(DecisionModel decisionModel) throws Exception;

    Object postDecisionScheme(DecisionScheme decisionScheme) throws Exception;

    Object postSetRecommend(DecisionScheme decisionScheme) throws Exception;

    Object postDecisionSchemeName(DecisionSchemeNameVO decisionSchemeNameVO) throws Exception;

    Object postDecisionMakingScheme(DecisionMakingSchemeVO decisionMakingSchemeVO) throws Exception;

    Object postBanModel(String evlModelCode, Boolean setOrBan) throws Exception;

    Object deleteDecisionScheme(String id) throws Exception;

    Object postSwitchAIAssistant(String evlModelCode, Boolean useAI) throws Exception;
}
