package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.kg.authority.AuthorityConfigVO;

/**
 * 帮助服务
 * @javadoc
 */
@DWRestfulService
public interface IHelpService extends DWService {

    /**
     * 测试方法
     * @param data
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    @DWRequestMapping(path="/help/echo", method = { DWRequestMethod.POST })
    Object echo(Object data) throws Exception;

    //

    /**
     * 根据应用code和 ID获取租户基础数据
     * 2023S8 不同范式支持不同的基础资料入口-第二阶段 #14915
     * @param config
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    @DWRequestMapping(path="/help/tenantBasicDataByAppCodeAndId", method = { DWRequestMethod.POST })
    Object tenantBasicDataByAppCodeAndId(AuthorityConfigVO config) throws Exception;
}
