package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.DWService;

import java.util.Map;

/**
 * 机制模板服务
 * @javadoc
 */
public interface IMechanismTemplateService extends DWService {

    /**
     * 获取机制模板
     * @param mechanismTemplateId 机制模板ID
     * @return 机制模板内容
     * @throws Exception
     */
    Object getQuery(String mechanismTemplateId) throws Exception;

    /**
     * 创建或更新机制模板
     * @param mechanismTemplateId 机制模板ID
     * @param content 机制模板内容
     * @return
     * @throws Exception
     */
    Object put(String mechanismTemplateId, Map<String, Object> content) throws Exception;

    /**
     * 删除机制模板
     * @param mechanismTemplateId 机制模板ID
     * @return
     * @throws Exception
     */
    Object delete(String mechanismTemplateId) throws Exception;

    /**
     * 创建机制模板
     * @param content
     * @return
     * @throws Exception
     */
    Object post(Map<String, Object> content) throws Exception;

    /**
     * 更新机制模板
     * @param mechanismTemplateId 机制模板id
     * @param updatedContent 更新后的内容
     * @return
     * @throws Exception
     */
    Object post(String mechanismTemplateId, Map<String, Object> updatedContent) throws Exception;
}
