package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.annotation.ScheduledCall;
import com.digiwin.athena.knowledgegraph.vo.HandleParadigmListVo;
import com.digiwin.athena.knowledgegraph.dto.ParadigmDto;
import com.digiwin.athena.knowledgegraph.vo.ParadigmConditionVO;

import java.util.List;
import java.util.Map;

/**
 * 范式服务
 * @javadoc
 */
public interface IParadigmService extends DWService {

     /**
      * 获取范式条件
      * @param code
      * @return
      * @throws DWException
      */
     Object getParadigmCondition(String  code) throws DWException;

     /**
      * 保存范式条件
      * @param paradigmCondition
      * @return
      * @throws DWException
      */
     Object postSaveParadigmCondition(ParadigmConditionVO paradigmCondition) throws DWException;

     /**
      * 新增范式数据
      * @param paradigmDto 新增的范式数据
      */
     @AllowAnonymous
     Boolean postSaveParadigm(ParadigmDto paradigmDto) throws DWException;

     /**
      * 删除范式数据
      * @param code 范式编码
      */
     @AllowAnonymous
     Boolean postDeleteParadigm(String code) throws DWException;

     /**
      * 根据机制code保存范式条件
      * @param mechanismCode 机制code
      * @return
      * @throws DWException
      */
     Object getParadigmConditionByMechanismCode(String  mechanismCode) throws DWException;

     /**
      * 范式初始化
      * @return
      */
     @AllowAnonymous
     @ScheduledCall
     Object postHandleParadigmInit();

     /**
      * 根据应用code获取租户授权的范式
      * @param appCode 应用code
      * @return
      * @throws DWException
      */
     Object getParadigmsByAppCode(String appCode)  throws DWException;

     /**
      * 获取机制范式权限、指定应用下的范式集合、机制组件清单数据帮助tdd处理范式筛选记录
      * @param appCode 应用code
      * @param mechanismCodes 机制code集合
      */
     HandleParadigmListVo postHandleParadigmList(String appCode, List<String> mechanismCodes, String tenantId) throws DWException;


     /**
      * 处理共享范式，对数据进行加标签
      * @param list 范式集合
      */
     List<Map>  postHandleParadigmShare(List<Map> list) throws DWException;

}
