package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.knowledgegraph.po.TriplesRequest;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;

/**
 * 自主精进POC验证服务
 * @javadoc
 */
public interface ITriplesService extends DWService {

    /**
     * 自主精进POC-保存接口
     * @param triplesRequest
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    Object postTriplesSave(TriplesRequest triplesRequest) throws DWException;

    /**
     *  自主精进POC-删除接口
     * @param triplesRequest
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    Object postTriplesDel(TriplesRequest triplesRequest) throws DWException;

    /**
     *  自主精进POC-深度查询接口
     * @param triplesRequest
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postTriplesQuery(TriplesRequest triplesRequest) throws Exception;
}
