package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.knowledgegraph.po.BkRequest;
import com.digiwin.athena.knowledgegraph.po.SimpleRequest;
import com.digiwin.athena.knowledgegraph.po.ViewRequest;

/**
 * 视图服务
 * @javadoc
 */
public interface IViewService extends DWService {

    /**
     * 获取项目任务
     * @param code 项目code
     * @return
     * @throws DWException
     */
    Object getTest(String code) throws DWException;

    /**
     * 获取邮件
     * @param emailCode 邮件code
     * @param locale 多语言
     * @return
     * @throws DWException
     */
    Object getEmail(String emailCode,String locale) throws DWException;


    /**
     * 查询 bk 信息
     * 替换至接口：/restful/standard/datamap/view/bK
     */
    @Deprecated
    Object postBk(BkRequest request) throws DWException;

    /**
     * 获取校验规则
     * 替换至接口：/restful/standard/datamap/view/bKMeta
     */
    @Deprecated
    Object postBkMeta(BkRequest request) throws DWException;

    /**
     * 根据url和方法查询datamap方法
     * @param request 查询参数
     * @return
     * @throws DWException
     */
    Object postDataMap(SimpleRequest request) throws DWException;

    /**
     * 根据url和方法查询datamap方法
     * @param request 查询参数
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    Object postDataMapPublic(SimpleRequest request) throws DWException;

}
