package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.CardPresentConfig;
import com.digiwin.athena.knowledgegraph.domain.WorkbenchSetting;
import com.digiwin.athena.knowledgegraph.enums.WSConfigType;
import com.digiwin.athena.knowledgegraph.enums.WSPageCode;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WorkbenchSettingVO;
import com.digiwin.athena.knowledgegraph.workbenchSetting.CardPresentConfigReq;
import com.digiwin.athena.knowledgegraph.workbenchSetting.WorkbenchSettingSaveRequest;

import javax.smartcardio.Card;
import java.util.List;

/**

 * 交付设计器，待办工作台配置
 * @javadoc
 */
public interface IWorkbenchSettingService extends DWService {

    /**
     * 查询交付设计器，待办工作台配置
     * 替换至接口：/restful/standard/datamap/workbenchSetting
     * @param pageCode
     * @param configType
     * @return
     */
    @Deprecated
    WorkbenchSettingVO getWorkbenchSetting(WSPageCode pageCode, WSConfigType configType,Boolean appCondition);

    /**
     * 查询交付设计器租户级配置
     *
     * @param pageCode
     * @param configTypes
     * @return
     */
    List<WorkbenchSetting> getWorkbenchTenantSetting(WSPageCode pageCode, List<WSConfigType> configTypes);

    /**
     * 重置交付设计器，待办工作台配置
     *
     * @param pageCode
     * @param configType
     * @return
     */
    WorkbenchSettingVO deleteWorkbenchSetting(WSPageCode pageCode, WSConfigType configType) throws Exception;

    /**
     * 保存交付设计器，待办工作台配置
     *
     * @param workbenchSettingSaveRequest
     * @throws DWBusinessException
     */
    void saveWorkbenchSetting(WorkbenchSettingSaveRequest workbenchSettingSaveRequest) throws DWBusinessException;

    /**
     * 获取卡片布局配置列表
     *
     * @param pageCode
     * @return
     */
    List<CardPresentConfig> getCardPresentConfig(String pageCode);

    /**
     * 保存卡片布局配置
     *
     * @param cardPresentConfigReq
     */
    void postSaveCardPresentConfig(CardPresentConfigReq cardPresentConfigReq);


}
