package com.digiwin.athena.knowledgegraph.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.ActionRequestMetadataDTO;
import com.digiwin.athena.kg.action.ActionResponseMetadataDTO;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import io.seata.common.util.CollectionUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @title: KgService
 * @projectName: kg
 * @description: KgService
 * @author: linc
 * @date 2023/7/17 16:42
 * @version: 1.0
 */
@Slf4j
@Service
public class KgService {
    @Value("${knowledgeGraphUrl}")
    private String knowledgeGraphUrl;

    private String kghost=null;

    @Autowired
    HttpServletRequest request;

    @Autowired
    @Qualifier("routeRestTemplate")
    RestTemplate restTemplate;

    @Autowired
    private ActionRepository actionRepository;

    @Autowired
    private DataPickService dataPickService;


    public Object requestKg(String service, String httpMethod, Map<String,Object> params)  {

        try {
            HttpEntity<Map> requestEntity = new HttpEntity<>(params, new HttpHeaders());
            ResponseEntity<Object> resEntity = this.restTemplate.exchange(knowledgeGraphUrl+"/restful/service/knowledgegraph/"+ service, HttpMethod.POST, requestEntity, Object.class);
            JSONObject result = JSON.parseObject(JSON.toJSONString(resEntity.getBody()));
            if (null != result && result.getIntValue("status") == HttpStatus.OK.value()) {
                return result;
            }
        }catch (Exception e) {
            log.error("requestKg mdc:{}",e);
        }
        return null;

    }

    public Object requestKg(String service, String httpMethod, Map<String,Object> params, String routerKey){
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("routerKey",routerKey);
            HttpEntity<Map> requestEntity = new HttpEntity<>(params, headers);
            ResponseEntity<Object> resEntity = this.restTemplate.exchange(knowledgeGraphUrl+"/restful/service/knowledgegraph/"+ service, HttpMethod.POST, requestEntity, Object.class);
            JSONObject result = JSON.parseObject(JSON.toJSONString(resEntity.getBody()));
            if (null != result && result.getIntValue("status") == HttpStatus.OK.value()) {
                return result;
            }
        }catch (Exception e) {
            log.error("requestKg mdc:{}",e);
        }
        return null;

    }

    public List<ApiDataFieldMetadataDTO> getActionParameters(String actionId, String tenantId, String tenantVersion) {
        ActionMetadataDTO responseDTO = null;
        try {
            responseDTO = this.getActionMetadata(actionId, tenantId, tenantVersion);
        } catch (Exception e) {
            log.error("getActionParameters error:{}",e);
        }
        if (responseDTO != null && responseDTO.getRequest() != null) {
            return responseDTO.getRequest().getParameters();
        }else {
            return Collections.emptyList();
        }
    }

    public ApiDataFieldMetadataDTO getActionResponse(String actionId, String tenantId, String tenantVersion) {
        ActionMetadataDTO responseDTO = null;
        try {
            responseDTO = this.getActionMetadata(actionId, tenantId, tenantVersion);
        } catch (Exception e) {
            log.error("getActionResponse error:{}",e);
        }
        if (responseDTO != null && responseDTO.getRequest() != null) {
            return responseDTO.getResponse().getData();
        }else {
            return null;
        }
    }

    public EspActionMetadataDTO getActionMetadata(String actionId, String tenantId, String tenantVersion) throws Exception {
        List<Action> actionAndLabels = dataPickService.excludeWithSameCode(actionRepository.findByActionIdAndVersion(actionId, tenantVersion));
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionId, tenantId));
        }
        Action action = actionAndLabels.get(0);
        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(actionId);
        metadataDTO.setServiceName(action.getServiceName());
        metadataDTO.setIdempotency(action.getIdempotency());

        //去除转义字符
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray(action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));

        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData(JSON.parseObject(action.getResponse_object(), ApiDataFieldMetadataDTO.class));

        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);

        return metadataDTO;
    }

}
