package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

@Service
public class OperationUnitService {


    public String getEocLevel(Map<String,String> eocMap){
        OperationUnit operationUnit = this.transToOperationUnit(eocMap);
        return getEocLevel(operationUnit);
    }
    /**
     * 根据运营单元信息获取级别，null 表示集团级
     * @param operationUnit
     * @return
     */
    public String getEocLevel(OperationUnit operationUnit){
        if(operationUnit == null || operationUnit.isEmpty()){
            return null;
        }
        String level = null;
        if (StringUtils.isNotEmpty(operationUnit.getEoc_region_id()) &&
                StringUtils.isEmpty(operationUnit.getEoc_company_id()) &&
                StringUtils.isEmpty(operationUnit.getEoc_site_id())) {
            level = "region";
        }
        if (StringUtils.isEmpty(operationUnit.getEoc_region_id()) &&
                StringUtils.isNotEmpty(operationUnit.getEoc_company_id()) &&
                StringUtils.isNotEmpty(operationUnit.getEoc_site_id())) {
            level = "site";
        }
        if (StringUtils.isEmpty(operationUnit.getEoc_region_id()) &&
                StringUtils.isNotEmpty(operationUnit.getEoc_company_id()) &&
                StringUtils.isEmpty(operationUnit.getEoc_site_id())) {
            level = "company";
        }
        if (operationUnit.getOperation_unit_v2() != null && StringUtils.isNotEmpty(operationUnit.getOperation_unit_v2().getEoc_mapping_id())) {
            // 根节点（集团级）直接返回null
            level = operationUnit.isRegion() ? null : operationUnit.getOperation_unit_v2().getEoc_mapping_id();
        }
        return level;
    }

    public boolean isEocMatch(Map fieldEocLevelMap, String eocLevel, String product){
        //都是集团级
        if(fieldEocLevelMap == null && eocLevel == null){
            return true;
        }

        if(fieldEocLevelMap != null && eocLevel != null){
            Object fieldEocLevelObj = fieldEocLevelMap.get(product);
            if(ObjectUtils.isEmpty(fieldEocLevelObj)){
                fieldEocLevelObj = fieldEocLevelMap.get("");
            }

            return StringUtils.equalsIgnoreCase(String.valueOf(fieldEocLevelObj), eocLevel);
        }

        return false;
    }



    public Criteria addOperationToCriteria(OperationUnit operationUnit, Criteria criteria){
        String companyId = null;
        String siteId = null;
        String regionId = null;
        if (operationUnit != null && !operationUnit.isEmpty()) {
            companyId = operationUnit.getEoc_company_id();
            siteId = operationUnit.getEoc_site_id();
            regionId = operationUnit.getEoc_region_id();
        }

        if (StringUtils.isNotEmpty(companyId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_company_id").is(companyId));
        }else{
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_company_id").is(null));
        }
        if (StringUtils.isNotEmpty(siteId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_site_id").is(siteId));
        }else{
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_site_id").is(null));
        }
        if (StringUtils.isNotEmpty(regionId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_region_id").is(regionId));
        }else{
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.eoc_region_id").is(null));
        }
        if (operationUnit != null && operationUnit.getOperation_unit_v2() != null && StringUtils.isNotEmpty(operationUnit.getOperation_unit_v2().getEoc_mapping_id())) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit.operation_unit_v2.eoc_mapping_id").is(operationUnit.getOperation_unit_v2().getEoc_mapping_id()));
        }
//        if(StringUtils.isEmpty(companyId) && StringUtils.isEmpty(siteId) && StringUtils.isEmpty(regionId)){
//            criteria = new Criteria().andOperator(criteria, Criteria.where("operationUnit").is(null));
//        }
        return criteria;
    }

    public Criteria addEocMapToCriteria(OperationUnit operationUnit, Criteria criteria){
        String companyId = null;
        String siteId = null;
        String regionId = null;
        if (operationUnit != null && !operationUnit.isEmpty()) {
            companyId = operationUnit.getEoc_company_id();
            siteId = operationUnit.getEoc_site_id();
            regionId = operationUnit.getEoc_region_id();
        }

        if (StringUtils.isNotEmpty(companyId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocMap.eocCompanyId").is(companyId));
        }else{
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocMap.eocCompanyId").is(null));
        }
        if (StringUtils.isNotEmpty(siteId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocMap.eocSiteId").is(siteId));
        }else{
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocMap.eocSiteId").is(null));
        }
        if (StringUtils.isNotEmpty(regionId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocMap.eocRegionId").is(regionId));
        }else{
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocMap.eocRegionId").is(null));
        }
        if (operationUnit != null && operationUnit.getOperation_unit_v2() != null && StringUtils.isNotEmpty(operationUnit.getOperation_unit_v2().getEoc_mapping_id())) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocMap.operation_unit_v2.eoc_mapping_id").is(operationUnit.getOperation_unit_v2().getEoc_mapping_id()));
        }
        return criteria;
    }

    public Map<String, Object> transToEocMap(OperationUnit operationUnit){
        Map<String,Object> eocMap = new HashMap<>();
        if(operationUnit != null){
            eocMap.put("eocCompanyId", StringUtils.isEmpty(operationUnit.getEoc_company_id())?"":operationUnit.getEoc_company_id());
            eocMap.put("eocSiteId", StringUtils.isEmpty(operationUnit.getEoc_site_id())?"":operationUnit.getEoc_site_id());
            eocMap.put("eocRegionId", StringUtils.isEmpty(operationUnit.getEoc_region_id())?"":operationUnit.getEoc_region_id());
            eocMap.put("operationUnitV2", operationUnit.getOperation_unit_v2());
        }

        return eocMap;
    }

    public EocMapDTO transToEocMapDTO(OperationUnit operationUnit){
        EocMapDTO eocMapDTO = new EocMapDTO();
        if(operationUnit != null){
            eocMapDTO.setEocCompanyId(operationUnit.getEoc_company_id());
            eocMapDTO.setEocSiteId(operationUnit.getEoc_site_id());
            eocMapDTO.setEocRegionId(operationUnit.getEoc_region_id());
            eocMapDTO.setOperation_unit_v2(operationUnit.getOperation_unit_v2());
        }

        return eocMapDTO;
    }

    public OperationUnit transToOperationUnit(Map<String,String> eocMap){
        OperationUnit operationUnit = new OperationUnit();
        if(!ObjectUtils.isEmpty(eocMap)){
            operationUnit.setEoc_company_id(eocMap.get("eocCompanyId"));
            operationUnit.setEoc_site_id(eocMap.get("eocSiteId"));
            operationUnit.setEoc_region_id(eocMap.get("eocRegionId"));
        }
        return operationUnit;
    }

    public OperationUnit transToOperationUnit(EocMapDTO eocMap){
        OperationUnit operationUnit = new OperationUnit();
        if(!ObjectUtils.isEmpty(eocMap)){
            operationUnit.setEoc_company_id(eocMap.getEocCompanyId());
            operationUnit.setEoc_site_id(eocMap.getEocSiteId());
            operationUnit.setEoc_region_id(eocMap.getEocRegionId());
            operationUnit.setOperation_unit_v2(eocMap.getOperation_unit_v2());
        }
        return operationUnit;
    }
}
