package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.athena.knowledgegraph.utils.Utils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class TagSystemService {

    @Value("${tagSystemUrl}")
    private String tagSystemUrl;
    @Autowired
    @Qualifier("routeRestTemplate")
    RestTemplate restTemplate;

    @Autowired
    @Qualifier("tagSystemRestTemplate")
    RestTemplate tagSystemRestTemplate;


    public Object syncTags(Map<String,Object> param){
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        Utils.requiredHeaders(headers);
        Map<String,Object> params = new HashMap<>();
        params.put("req",param);
        HttpEntity<Object> requestEntity = new HttpEntity<>(params, headers);
        ResponseEntity<Object> resEntity = tagSystemRestTemplate.exchange(tagSystemUrl + "/restful/service/tagsystem/tag/batchTags", HttpMethod.POST, requestEntity, Object.class);
        return resEntity.getBody();
    }

    public Object cleanTags(Map<String,Object> param){
        //Map<String,Object> params = new HashMap<>();
        //params.put("req",param);
        //DapResponse resp = Utils.request(tagSystemUrl+"/tag/cleanPlugin","post",params);
        //return resp.getResponse();
        return null;
    }

    /**
     * 初始化tag数据，存入redis
     * 目前只初始化performer和charge两个relationId的数据
     * @return Object
     */
    public Object initTagData(){
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        Utils.requiredHeaders(headers);
        Map<String,Object> params = new HashMap<>();
        HttpEntity<Object> requestEntity = new HttpEntity<>(params, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(tagSystemUrl + "/restful/service/tagsystem/tagRelation/initTagData", HttpMethod.POST, requestEntity, Object.class);
        return resEntity.getBody();
    }
}
