package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.po.CommonResp;
import com.digiwin.athena.knowledgegraph.po.MongoCrudReq;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IBatchService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.model.BatchRequest;
import com.digiwin.athena.knowledgegraph.service.model.TaskActivityReq;
import org.apache.commons.collections.CollectionUtils;
import org.bson.types.ObjectId;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-01-13 09:22
 **/
@Lang
@Service
public class BatchService implements IBatchService {

    @Autowired
    TaskRepository taskRepository;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    KgInnerService kgInnerService;

    @Override
    public Object postTaskBasic(BatchRequest q) throws DWBusinessException {
        if(CollectionUtils.isEmpty(q.getCodes())){
            return null;
        }
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<Task> tasks = taskRepository.getTasksByCode(tenantId,q.getCodes(), tenantVersion);
//        if(tasks.size()>0){
//            Query query1 = Query.query(Criteria.where("code").in(q.getCodes()).and("version").is(tenantVersion));
//            query1.fields().include("code").include("assignAble").include("assignTo").include("version");
//            List<Task> tasksInSystem = mongoTemplate.find(query1,Task.class,"taskConfigs");
//            Query query2 = Query.query(Criteria.where("code").in(q.getCodes()).and("tenantId").is(tenantId));
//            query2.fields().include("code").include("assignAble").include("assignTo").include("version");
//            List<Task> tasksInTenant = mongoTemplateUser.find(query2,Task.class,"taskConfigs");
//
//            AthenaUtils.mergeList(tasksInSystem,tasks);
//            AthenaUtils.mergeList(tasksInTenant,tasks);
//        }
//
//        tasks.forEach(t->{
//            t.setTaskId(t.getCode());
//        });

        List datamapTasks = dataMapService.batchProjects(q.getCodes());
//        if(CollectionUtils.isNotEmpty(datamapTasks)){
//            tasks.addAll(datamapTasks);
//        }



        return datamapTasks;
    }

    @Override
    public Object postActivityBasic(BatchRequest q) throws DWBusinessException {

        if(CollectionUtils.isEmpty(q.getTaskAndActivities())){
            return null;
        }
//        Session session = sessionFactory.openSession();
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        StringBuilder sb = new StringBuilder();
//        List<String> codes2 = new ArrayList<>();
//        int len = q.getTaskAndActivities().size();
//        for(int i=0;i<len;i++){
//            TaskActivityReq ta = q.getTaskAndActivities().get(i);
//            if(null!=ta.getTaskCode() && null!=ta.getActivityCode()){
//                codes2.add(ta.getActivityCode());
//                sb.append("match(task:Task{code:'").append(ta.getTaskCode())
//                        .append("'})-[:Contains]->(activity:Activity{code:'").append(ta.getActivityCode()).append("'}) ").append("where task.tenantId in [null,'SYSTEM','"+tenantId+"']").append(" return activity");
//                if(i<len-1){
//                    sb.append(" union ");
//                }
//
//            }
//        }
//
//        List<Activity> activities = new ArrayList<>();
//        List<String> codes = new ArrayList<>();
//        Iterable<Activity> activitiesNeo4j =  session.query(Activity.class,sb.toString(),new HashMap<>());
//        activitiesNeo4j.forEach(a->{
//            activities.add(a);
//            codes.add(a.getCode());
//        });
//        if(codes.size()>0){
//            Query query1 = Query.query(Criteria.where("code").in(codes).and("version").is(tenantVersion));
//            query1.fields().include("code").include("assignAble").include("assignTo").include("version");
//            List<Activity> activitiesInSystem = mongoTemplate.find(query1,Activity.class,"activityConfigs");
//            Query query2 = Query.query(Criteria.where("code").in(codes).and("tenantId").is(tenantId));
//            query2.fields().include("code").include("assignAble").include("assignTo").include("version");
//            List<Activity> activitiesInTenant = mongoTemplateUser.find(query2,Activity.class,"activityConfigs");
//            AthenaUtils.mergeList(activitiesInSystem,activities);
//            AthenaUtils.mergeList(activitiesInTenant,activities);
//        }
//
//
//        activities.forEach(a->{
//            a.setActivityId(a.getCode());
//        });
//
//        List datamapActivities= dataMapService.batchTasks(codes2);
//        if(CollectionUtils.isNotEmpty(datamapActivities)){
//            activities.addAll(datamapActivities);
//        }
//
//
//
//        return activities;


        List<String> codes2 = new ArrayList<>();
        int len = q.getTaskAndActivities().size();
        for(int i=0;i<len;i++){
            TaskActivityReq ta = q.getTaskAndActivities().get(i);
            if(null!=ta.getTaskCode() && null!=ta.getActivityCode()){
                codes2.add(ta.getActivityCode());
            }
        }
        List datamapActivities= dataMapService.batchTasks(codes2);
        return datamapActivities;

    }

    @Override
    public CommonResp postMongo(MongoCrudReq q) throws DWBusinessException {

        MongoTemplate template = mongoTemplate;
        if("user".equalsIgnoreCase(q.getDb())){
            template = mongoTemplateUser;
        }


        CommonResp obj=new CommonResp();

        Query query1 = new Query();
        q.getQuery().forEach((k,v)->{
            if(v instanceof Collection){
                List list = new ArrayList();
                Collection collection = (Collection) v;
                collection.forEach(ele->{list.add(ele);});
                query1.addCriteria(Criteria.where(k).in(list));
            }else{
                query1.addCriteria(Criteria.where(k).is(v));
            }
        });

        switch (q.getOp()){
            case "select":
                List<Map> list =  template.find(query1, Map.class, q.getCol());
                for(Map doc:list){
                    try {
                        ObjectId objectId= (ObjectId) doc.get("_id");
                        doc.put("_id",objectId.toHexString() );
                    }catch (Exception e){}
                }
                obj.setData(list);
                break;
            case "insert":
                template.insert(q.getDocs(),q.getCol());
                break;
            case "save":
                Map doc = (Map) q.getDoc();
                String _id = (String) doc.get("_id");
                if(null!=_id){
                    ObjectId objectId = new ObjectId(_id);
                    doc.put("_id",objectId);

                }
                template.save(q.getDoc(),q.getCol());
                break;
            case "delete":
              //  template.remove(query1,q.getCol());
                break;
        }


        return obj;
    }


}
