package com.digiwin.athena.knowledgegraph.service.impl;


import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.Duty;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.repository.neo4j.DutyRepository;
import com.digiwin.athena.knowledgegraph.service.IDutyService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-09-22 09:06
 **/
@Lang
@Service
public class DutyService  implements IDutyService {

    static Logger logger = LoggerFactory.getLogger(DutyService.class);

    static Log log = LogFactory.getLog(DutyService.class);

    @Autowired
    private DutyRepository repository;

    @Value("${iamApToken}")
    String appToken;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    AppService appService;

    @Autowired
    AppMetaCaller appMetaCaller;

    @Override
    public Object getDutyByCode(String code) {


        //return repository.findOneByCode(code);
        Map<String,Object> map = AppMetaCaller.of("code",code);
        RespObject respObject = appMetaCaller.call("/duty/dutyByCode","get",map,RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object getList() {

//        List<Duty> dutyList = new ArrayList<>();
//        repository.findAll().forEach(d->{
//            dutyList.add(d);
//        });
//
//        return dutyList;
        RespObject respObject = appMetaCaller.call("/duty/list","get",null,RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object syncAllDuty() throws DWBusinessException {
//        List<Duty> dutyList = (List<Duty>) getList();
//        int count = 0;
//
//        for(Duty d:dutyList){
//            Map<String,Object> param = new HashMap<>();
//            param.put("id",d.getCode());
//            param.put("name",d.getName());
//            param.put("modify",true);
//            String resp = AthenaUtils.postEoc("/api/eoc/v2/duty",null, JSON.toJSONString(param), appToken);
//        }
//
//        return null;
        RespObject respObject = appMetaCaller.call("/duty/syncAllDuty","get",null,RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object syncAllDuty(String token, String appCode, String tenantId) throws Exception {
//        List<Duty> dutyList = (List<Duty>) getList();
//        //根据应用查询所有关联Duty
//        List<ApplicationRelation> applicationRelations = appService.getApplicationRelationByTypeAndAppCode("duty", appCode);
//        List<String> appDutyCodes = CollectionUtils.isEmpty(applicationRelations) ?
//                Collections.EMPTY_LIST : applicationRelations.stream().map(ApplicationRelation::getCode)
//                .collect(Collectors.toList());
//        //对dutyList过滤
//        for (Duty d : dutyList) {
//            if (appDutyCodes.contains(d.getCode())) {
//                Map<String, Object> param = new HashMap<>();
//                param.put("id", d.getCode());
//                param.put("name", d.getName());
//                param.put("modify", true);
//                String resp = AthenaUtils.postEoc("/api/eoc/v2/duty", null, JSON.toJSONString(param), token, appToken);
//            }
//        }
//
//        return null;
        Map<String,Object> map = AppMetaCaller.of("token",token);
        map.put("appCode",appCode);
        map.put("tenantId",tenantId);
        RespObject respObject = appMetaCaller.call("/duty/syncAllDuty","get",map,RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object syncAllDuty(String token) throws DWBusinessException {
//        List<Duty> dutyList = (List<Duty>) getList();
//        int count = 0;
//
//        for(Duty d:dutyList){
//            Map<String,Object> param = new HashMap<>();
//            param.put("id",d.getCode());
//            param.put("name",d.getName());
//            param.put("modify",true);
//            String resp = AthenaUtils.postEoc("/api/eoc/v2/duty",null, JSON.toJSONString(param), token, appToken);
//        }
//
//        return null;
        Map<String,Object> map = AppMetaCaller.of("token",token);
        RespObject respObject = appMetaCaller.call("/duty/syncAllDuty","get",map,RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object getTest(String p) {

        Map<String,Object> map = AppMetaCaller.of("p",p);
        RespObject respObject = appMetaCaller.call("/duty/test","get",map,RespObject.class);
        return respObject.getResponse();
    }


//    @ApolloConfigChangeListener
//    private void someOnChange(ConfigChangeEvent changeEvent) {
//        System.out.println(changeEvent);
//    }
}
